/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRootyDirt
extends Block
implements ITreePart {
    static String name = "rootydirt";
    public static final PropertyInteger LIFE = PropertyInteger.func_177719_a((String)"life", (int)0, (int)15);
    public static final PropertyEnum MIMIC = PropertyEnum.func_177709_a((String)"mimic", EnumMimicType.class);

    public BlockRootyDirt() {
        this(name);
    }

    public BlockRootyDirt(String name) {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIFE, (Comparable)Integer.valueOf(15)).func_177226_a((IProperty)MIMIC, (Comparable)((Object)EnumMimicType.DIRT)));
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIFE, MIMIC});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIFE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LIFE);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)MIMIC, (Comparable)((Object)this.getMimicType(worldIn, pos)));
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        this.updateTree(world, pos, random, false);
    }

    public EnumFacing getTrunkDirection(IBlockAccess access, BlockPos rootPos) {
        return EnumFacing.UP;
    }

    public boolean updateTree(World world, BlockPos rootPos, Random random, boolean rapid) {
        BlockPos treePos;
        ITreePart treeBase;
        Species species = this.getSpecies(world, rootPos);
        boolean viable = false;
        if (species != null && (treeBase = TreeHelper.getTreePart((IBlockAccess)world, treePos = rootPos.func_177972_a(this.getTrunkDirection((IBlockAccess)world, rootPos)))) != null && CoordUtils.isSurroundedByLoadedChunks(world, rootPos)) {
            viable = species.update(world, this, rootPos, this.getSoilLife((IBlockAccess)world, rootPos), treeBase, treePos, random, rapid);
        }
        if (!viable) {
            world.func_180501_a(rootPos, this.getDecayBlockState((IBlockAccess)world, rootPos), 3);
        }
        return viable;
    }

    public IBlockState getDecayBlockState(IBlockAccess access, BlockPos pos) {
        return Blocks.field_150346_d.func_176223_P();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return 20.0f;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return this.getSoilLife((IBlockAccess)world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        DynamicTree tree = this.getTree((IBlockAccess)world, pos);
        if (tree != null) {
            return tree.onTreeActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public void destroyTree(World world, BlockPos pos) {
        BlockBranch branch = TreeHelper.getBranch((IBlockAccess)world, pos.func_177984_a());
        if (branch != null) {
            branch.destroyEntireTree(world, pos.func_177984_a());
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.destroyTree(world, pos);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.destroyTree(world, pos);
    }

    public int getSoilLife(IBlockAccess blockAccess, BlockPos pos) {
        return (Integer)blockAccess.func_180495_p(pos).func_177229_b((IProperty)LIFE);
    }

    public void setSoilLife(World world, BlockPos pos, int life) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)LIFE, (Comparable)Integer.valueOf(MathHelper.clamp(life, 0, 15))), 3);
        world.func_175685_c(pos, (Block)this);
    }

    public boolean fertilize(World world, BlockPos pos, int amount) {
        int soilLife = this.getSoilLife((IBlockAccess)world, pos);
        if (soilLife == 0 && amount < 0 || soilLife == 15 && amount > 0) {
            return false;
        }
        this.setSoilLife(world, pos, soilLife + amount);
        return true;
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, DynamicTree leavesTree) {
        return Cells.nullCell;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int getRadiusForConnection(IBlockAccess blockAccess, BlockPos pos, BlockBranch from, int fromRadius) {
        return 8;
    }

    @Override
    public int probabilityForBlock(IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return 0;
    }

    @Override
    public int getRadius(IBlockAccess blockAccess, BlockPos pos) {
        return 0;
    }

    public MapSignal startAnalysis(World world, BlockPos rootPos, MapSignal signal) {
        EnumFacing dir = this.getTrunkDirection((IBlockAccess)world, rootPos);
        BlockPos treePos = rootPos.func_177972_a(dir);
        TreeHelper.getSafeTreePart((IBlockAccess)world, treePos).analyse(world, treePos, null, signal);
        return signal;
    }

    @Override
    public MapSignal analyse(World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        signal.run(world, this, pos, fromDir);
        signal.root = pos;
        signal.found = true;
        return signal;
    }

    @Override
    public int branchSupport(IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return dir == EnumFacing.DOWN ? 17 : 0;
    }

    @Override
    public DynamicTree getTree(IBlockAccess blockAccess, BlockPos pos) {
        BlockPos treePos = pos.func_177972_a(this.getTrunkDirection(blockAccess, pos));
        return TreeHelper.isBranch(blockAccess, treePos) ? TreeHelper.getBranch(blockAccess, treePos).getTree(blockAccess, treePos) : null;
    }

    public Species getSpecies(World world, BlockPos pos) {
        BlockPos treePos = pos.func_177972_a(this.getTrunkDirection((IBlockAccess)world, pos));
        return TreeHelper.isBranch((IBlockAccess)world, treePos) ? TreeHelper.getBranch((IBlockAccess)world, treePos).getTree((IBlockAccess)world, treePos).getSpeciesForLocation(world, treePos) : null;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public EnumMimicType getMimicType(IBlockAccess blockAccess, BlockPos pos) {
        int[] dMap;
        for (int depth : dMap = new int[]{0, -1, 1}) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                IBlockState mimic = blockAccess.func_180495_p(pos.func_177972_a(dir).func_177979_c(depth));
                for (EnumMimicType muse : EnumMimicType.values()) {
                    if (muse == EnumMimicType.DIRT || mimic != muse.getBlockState()) continue;
                    return muse;
                }
            }
        }
        return EnumMimicType.DIRT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        Random rand = world.field_73012_v;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
        double d0 = (double)x + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.2) + 0.1 + axisalignedbb.field_72340_a;
        double d1 = (double)y + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.2) + 0.1 + axisalignedbb.field_72338_b;
        double d2 = (double)z + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.2) + 0.1 + axisalignedbb.field_72339_c;
        switch (target.field_178784_b) {
            case DOWN: {
                d1 = (double)y + axisalignedbb.field_72338_b - 0.1;
                break;
            }
            case UP: {
                d1 = (double)y + axisalignedbb.field_72337_e + 0.1;
                break;
            }
            case NORTH: {
                d2 = (double)z + axisalignedbb.field_72339_c - 0.1;
                break;
            }
            case SOUTH: {
                d2 = (double)z + axisalignedbb.field_72334_f + 0.1;
                break;
            }
            case WEST: {
                d0 = (double)x + axisalignedbb.field_72340_a - 0.1;
                break;
            }
            case EAST: {
                d0 = (double)x + axisalignedbb.field_72336_d + 0.1;
            }
        }
        ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        particle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f).func_70538_b(0.6f, 0.6f, 0.6f);
        return true;
    }

    @Override
    public boolean isRootNode() {
        return true;
    }

    @Override
    public boolean isBranch() {
        return false;
    }

    public static enum EnumMimicType implements IStringSerializable
    {
        DIRT(ModBlocks.blockStates.dirt, "dirt"),
        GRASS(Blocks.field_150349_c.func_176223_P(), "grass"),
        PODZOL(ModBlocks.blockStates.podzol, "podzol"),
        MYCELIUM(Blocks.field_150391_bh.func_176223_P(), "mycelium"),
        COARSEDIRT(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT), "coarsedirt"),
        SNOWY(Blocks.field_150349_c.func_176223_P().func_177226_a((IProperty)BlockGrass.field_176498_a, (Comparable)Boolean.valueOf(true)), "snowy");

        private final IBlockState muse;
        private final String name;

        private EnumMimicType(IBlockState muse, String name) {
            this.muse = muse;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public IBlockState getBlockState() {
            return this.muse;
        }
    }
}

