/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.compat.QuarkProxyBase;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.tweaks.feature.GreenerGrass;

public class QuarkProxyActiveClient
extends QuarkProxyBase {
    private GreenerGrass greenerGrass;
    private Method registrationMethod;
    private boolean affectFolliage;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init() {
        this.crackQuark();
        if (this.greenerGrass != null && this.greenerGrass.enabled) {
            this.registerGreenerColor(ModBlocks.blockRootyDirt);
            if (this.affectFolliage) {
                HashMap<Integer, BlockDynamicLeaves> map = TreeHelper.getLeavesMapForModId("dynamictrees");
                for (BlockDynamicLeaves leaves : map.values()) {
                    this.registerGreenerColor((Block)leaves);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void crackQuark() {
        this.greenerGrass = (GreenerGrass)ModuleLoader.featureInstances.get(GreenerGrass.class);
        if (this.greenerGrass != null && this.greenerGrass.enabled) {
            this.registrationMethod = ReflectionHelper.findMethod(GreenerGrass.class, (Object)this.greenerGrass, (String[])new String[]{"registerGreenerColor"}, (Class[])new Class[]{Block[].class});
            this.affectFolliage = this.greenerGrass.loadPropBool("Should affect folliage", "", true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerGreenerColor(Block block) {
        if (this.registrationMethod != null) {
            try {
                this.registrationMethod.invoke((Object)this.greenerGrass, new Object[]{new Block[]{block}});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

