/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.genfeatures;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.List;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class GenFeatureVine
implements IGenFeature {
    protected final PropertyBool[] vineMap = new PropertyBool[]{null, null, BlockVine.field_176273_b, BlockVine.field_176279_N, BlockVine.field_176280_O, BlockVine.field_176278_M};
    protected int qty = 4;
    protected int maxLength = 8;
    protected float verSpread = 60.0f;
    protected float rayDistance = 5.0f;
    protected Species species;

    public GenFeatureVine(Species species) {
        this.species = species;
    }

    public GenFeatureVine setQuantity(int qty) {
        this.qty = qty;
        return this;
    }

    public GenFeatureVine setMaxLength(int length) {
        this.maxLength = length;
        return this;
    }

    public GenFeatureVine setVerSpread(float verSpread) {
        this.verSpread = verSpread;
        return this;
    }

    public GenFeatureVine setRayDistance(float rayDistance) {
        this.rayDistance = rayDistance;
        return this;
    }

    @Override
    public void gen(World world, BlockPos treePos, List<BlockPos> endPoints) {
        if (!endPoints.isEmpty()) {
            for (int i = 0; i < this.qty; ++i) {
                BlockPos endPoint = endPoints.get(world.field_73012_v.nextInt(endPoints.size()));
                this.addVine(world, this.species, treePos, endPoint);
            }
        }
    }

    protected void addVine(World world, Species species, BlockPos treePos, BlockPos branchPos) {
        RayTraceResult result = species.branchRayTrace(world, treePos, branchPos, 90.0f, this.verSpread, this.rayDistance);
        if (result != null) {
            BlockPos vinePos = result.func_178782_a().func_177972_a(result.field_178784_b);
            PropertyBool vineSide = this.vineMap[result.field_178784_b.func_176734_d().func_176745_a()];
            if (vineSide != null) {
                IBlockState vineState = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)vineSide, (Comparable)Boolean.valueOf(true));
                int len = MathHelper.clamp(world.field_73012_v.nextInt(this.maxLength) + 3, 3, this.maxLength);
                for (int i = 0; i < len && world.func_175623_d(vinePos); ++i) {
                    world.func_175656_a(vinePos, vineState);
                    vinePos = vinePos.func_177977_b();
                }
            }
        }
    }

    public static int coordHashCode(BlockPos pos) {
        int hash = (pos.func_177958_n() * 4111 ^ pos.func_177956_o() * 271 ^ pos.func_177952_p() * 3067) >> 1;
        return hash & 0xFFFF;
    }
}

