/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NodeCoder
implements INodeInspector {
    private ArrayList<Link> links = new ArrayList();

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        Link link = new Link(pos);
        for (int i = this.links.size() - 1; i >= 0; --i) {
            Link l = this.links.get(i);
            if (pos.func_177958_n() + fromDir.func_82601_c() != l.pos.func_177958_n() || pos.func_177956_o() + fromDir.func_96559_d() != l.pos.func_177956_o() || pos.func_177952_p() + fromDir.func_82599_e() != l.pos.func_177952_p()) continue;
            l.links[fromDir.func_176734_d().ordinal()] = link;
            link.links[fromDir.ordinal()] = l;
            l.forks = l.forks + (i != this.links.size() - 1 ? 1 : 0);
            break;
        }
        this.links.add(link);
        return false;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void compile(JoCode joCode, EnumFacing facingDir) {
        if (this.links.size() > 0) {
            this.nextLink(this.links.get(0), null, joCode);
        }
        joCode.rotate(facingDir);
    }

    private void nextLink(Link link, Link fromLink, JoCode joCode) {
        for (int i = 0; i < 6; ++i) {
            Link l = link.links[i];
            if (l == null || l == fromLink) continue;
            if (link.forks > 0) {
                joCode.addFork();
            }
            joCode.addDirection((byte)i);
            this.nextLink(l, link, joCode);
            if (link.forks <= 0) continue;
            joCode.addReturn();
            --link.forks;
        }
    }

    private class Link {
        BlockPos pos;
        int forks;
        Link[] links;

        public Link(BlockPos pos) {
            this.pos = pos;
            this.links = new Link[6];
        }
    }
}

