/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NodeInflator
implements INodeInspector {
    private float radius;
    private BlockPos last;
    Species species;
    SimpleVoxmap leafMap;

    public NodeInflator(Species species, SimpleVoxmap leafMap) {
        this.species = species;
        this.leafMap = leafMap;
        this.last = BlockPos.field_177992_a;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null) {
            this.radius = 1.0f;
        }
        return false;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null) {
            float areaAccum = this.radius * this.radius;
            boolean isTwig = true;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir.equals((Object)fromDir)) continue;
                BlockPos dPos = pos.func_177972_a(dir);
                if (dPos.equals((Object)this.last)) {
                    isTwig = false;
                    continue;
                }
                ITreePart treepart = TreeHelper.getTreePart((IBlockAccess)world, dPos);
                if (!branch.isSameWood(treepart)) continue;
                int branchRadius = treepart.getRadius((IBlockAccess)world, dPos);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (isTwig) {
                this.leafMap.setVoxel(pos, (byte)16);
                SimpleVoxmap leafCluster = branch.getTree().getLeafCluster();
                this.leafMap.BlitMax(pos, leafCluster);
            } else {
                this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                float secondaryThickness = this.species.getSecondaryThickness();
                if (this.radius < secondaryThickness) {
                    this.radius = secondaryThickness;
                }
                branch.setRadius(world, pos, (int)Math.floor(this.radius));
                this.leafMap.setVoxel(pos, (byte)32);
            }
            this.last = pos;
        }
        return false;
    }
}

