/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NodeTwinkle
implements INodeInspector {
    EnumParticleTypes particleType;
    int numParticles;

    public NodeTwinkle(EnumParticleTypes type, int num) {
        this.particleType = type;
        this.numParticles = num;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        if (world.field_72995_K && TreeHelper.isBranch(block)) {
            NodeTwinkle.spawnParticles(world, this.particleType, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), this.numParticles, world.field_73012_v);
        }
        return false;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public static void spawnParticles(World world, EnumParticleTypes particleType, int x, int y, int z, int numParticles, Random random) {
        for (int i1 = 0; i1 < numParticles; ++i1) {
            double mx = random.nextGaussian() * 0.02;
            double my = random.nextGaussian() * 0.02;
            double mz = random.nextGaussian() * 0.02;
            DynamicTrees.proxy.spawnParticle(world, particleType, (float)x + random.nextFloat(), (double)y + (double)random.nextFloat(), (double)z + (double)random.nextFloat(), mx, my, mz);
        }
    }
}

