/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModItems;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class DirtBucket
extends Item {
    public static final String name = "dirtbucket";

    public DirtBucket() {
        this(name);
    }

    public DirtBucket(String name) {
        this.func_77637_a(DynamicTrees.dynamicTreesTab);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77625_d(1);
        this.func_77642_a(this);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        BlockPos workingBlockPos;
        RayTraceResult raytraceresult = this.func_77621_a(world, player, false);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        if (!world.func_175660_a(player, blockpos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        boolean isReplacable = world.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)world, blockpos);
        BlockPos blockPos = workingBlockPos = isReplacable && raytraceresult.field_178784_b == EnumFacing.UP ? blockpos : blockpos.func_177972_a(raytraceresult.field_178784_b);
        if (!player.func_175151_a(workingBlockPos, raytraceresult.field_178784_b, itemStack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        if (this.tryPlaceContainedDirt(player, world, workingBlockPos)) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return !player.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(Items.field_151133_ar)) : new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    public boolean tryPlaceContainedDirt(@Nullable EntityPlayer player, World world, BlockPos posIn) {
        IBlockState iblockstate = world.func_180495_p(posIn);
        boolean replaceable = iblockstate.func_177230_c().func_176200_f((IBlockAccess)world, posIn);
        if (replaceable) {
            if (!world.field_72995_K) {
                world.func_175655_b(posIn, true);
            }
            SoundEvent soundevent = SoundEvents.field_187577_bU;
            world.func_184133_a(player, posIn, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(posIn, Blocks.field_150346_d.func_176223_P(), 11);
            return true;
        }
        return false;
    }

    public DirtBucket registerRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ModItems.dirtBucket), (Object[])new Object[]{Blocks.field_150346_d, Items.field_151133_ar});
        return this;
    }
}

