/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Seed
extends Item {
    private Species species;

    public Seed(String name) {
        this.func_77637_a(DynamicTrees.dynamicTreesTab);
        this.func_77655_b(name);
        this.setRegistryName(name);
    }

    public void setSpecies(Species species, ItemStack seedStack) {
        this.species = species;
    }

    public Species getSpecies(ItemStack seedStack) {
        return this.species;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        World world = CompatHelper.getEntityWorld((Entity)entityItem);
        if (entityItem.field_70173_aa >= ModConfigs.seedTimeToLive) {
            BlockPos pos;
            if (!world.field_72995_K && world.func_175710_j(pos = new BlockPos((Entity)entityItem))) {
                Random rand = new Random();
                ItemStack seedStack = CompatHelper.getEntityItem(entityItem);
                int count = CompatHelper.getStackCount(seedStack);
                while (!(count-- <= 0 || this.getSpecies(seedStack).biomeSuitability(world, pos) * ModConfigs.seedPlantRate > rand.nextFloat() && this.plantSapling(world, pos, seedStack))) {
                }
                CompatHelper.setStackCount(CompatHelper.getEntityItem(entityItem), 0);
            }
            entityItem.func_70106_y();
        }
        return false;
    }

    public EnumActionResult func_180614_a(ItemStack heldItem, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Species species;
        BlockBonsaiPot bonzaiPot;
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.equals(Blocks.field_150457_bL.func_176223_P()) && (bonzaiPot = (species = this.getSpecies(heldItem)).getTree().getBonzaiPot()).setSpecies(world, species, pos)) {
            CompatHelper.shrinkStack(heldItem, 1);
            return EnumActionResult.SUCCESS;
        }
        if (facing == EnumFacing.UP && player.func_175151_a(pos, facing, heldItem) && player.func_175151_a(pos.func_177984_a(), facing, heldItem) && this.plantSapling(world, pos.func_177984_a(), heldItem)) {
            CompatHelper.shrinkStack(heldItem, 1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean plantSapling(World world, BlockPos pos, ItemStack seedStack) {
        Species species = this.getSpecies(seedStack);
        if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && BlockDynamicSapling.canSaplingStay(world, species, pos)) {
            return species.placeSaplingBlock(world, pos);
        }
        return false;
    }
}

