/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class CompositeModel
implements IPerspectiveAwareModel {
    private ModelBlock modelBlock;
    TextureAtlasSprite barkParticles;
    private IBakedModel[][] sleeves = new IBakedModel[6][7];
    private IBakedModel[][] cores = new IBakedModel[3][8];
    private IBakedModel[] rings = new IBakedModel[8];

    public CompositeModel(ResourceLocation barkRes, ResourceLocation ringsRes, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.modelBlock = new ModelBlock(null, null, null, false, false, ItemCameraTransforms.field_178357_a, null);
        TextureAtlasSprite barkIcon = (TextureAtlasSprite)bakedTextureGetter.apply((Object)barkRes);
        TextureAtlasSprite ringIcon = (TextureAtlasSprite)bakedTextureGetter.apply((Object)ringsRes);
        this.barkParticles = barkIcon;
        for (int i = 0; i < 8; ++i) {
            int radius = i + 1;
            if (radius < 8) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    this.sleeves[dir.func_176745_a()][i] = this.bakeSleeve(radius, dir, barkIcon);
                }
            }
            this.cores[0][i] = this.bakeCore(radius, EnumFacing.Axis.Y, barkIcon);
            this.cores[1][i] = this.bakeCore(radius, EnumFacing.Axis.Z, barkIcon);
            this.cores[2][i] = this.bakeCore(radius, EnumFacing.Axis.X, barkIcon);
            this.rings[i] = this.bakeCore(radius, EnumFacing.Axis.Y, ringIcon);
        }
    }

    public IBakedModel bakeSleeve(int radius, EnumFacing dir, TextureAtlasSprite bark) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.func_82601_c() != 0 ? halfSize : dradius;
        int halfSizeY = dir.func_96559_d() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.func_82599_e() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.func_82601_c() * move;
        int centerY = 16 + dir.func_96559_d() * move;
        int centerZ = 16 + dir.func_82599_e() * move;
        Vector3f posFrom = new Vector3f((float)((centerX - halfSizeX) / 2), (float)((centerY - halfSizeY) / 2), (float)((centerZ - halfSizeZ) / 2));
        Vector3f posTo = new Vector3f((float)((centerX + halfSizeX) / 2), (float)((centerY + halfSizeY) / 2), (float)((centerZ + halfSizeZ) / 2));
        boolean bl = negative = dir.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (dir.func_176734_d() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 1) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.func_176740_k(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, this.makeBakedQuad(part, (BlockPartFace)e.getValue(), bark, face, (ITransformation)ModelRotation.X0_Y0, false));
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCore(int radius, EnumFacing.Axis axis, TextureAtlasSprite icon) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(icon);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            EnumFacing face = (EnumFacing)e.getKey();
            builder.func_177650_a(face, this.makeBakedQuad(part, (BlockPartFace)e.getValue(), icon, face, (ITransformation)ModelRotation.X0_Y0, false));
        }
        return builder.func_177645_b();
    }

    public int getFaceAngle(EnumFacing.Axis axis, EnumFacing face) {
        if (axis == EnumFacing.Axis.Y) {
            return 0;
        }
        if (axis == EnumFacing.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
            }
            return 90;
        }
        return face == EnumFacing.NORTH ? 270 : 90;
    }

    protected BakedQuad makeBakedQuad(BlockPart blockPart, BlockPartFace partFace, TextureAtlasSprite atlasSprite, EnumFacing dir, ITransformation transform, boolean uvlocked) {
        return new FaceBakery().makeBakedQuad(blockPart.field_178241_a, blockPart.field_178239_b, partFace, atlasSprite, dir, transform, blockPart.field_178237_d, uvlocked, blockPart.field_178238_e);
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        LinkedList<BakedQuad> quadsList = new LinkedList<BakedQuad>();
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)blockState;
        if (blockState instanceof IExtendedBlockState) {
            EnumFacing coreRingDir;
            int coreRadius = this.getRadius(blockState);
            int[] connections = this.pollConnections(coreRadius, extendedBlockState);
            int numConnections = 0;
            for (int i : connections) {
                numConnections += i != 0 ? 1 : 0;
            }
            EnumFacing sourceDir = this.getSourceDir(coreRadius, connections);
            if (sourceDir == null) {
                sourceDir = EnumFacing.DOWN;
            }
            int coreDir = this.resolveCoreDir(sourceDir);
            EnumFacing enumFacing = coreRingDir = numConnections == 1 ? sourceDir.func_176734_d() : null;
            if (side == null || coreRadius != connections[side.func_176745_a()]) {
                if (coreRingDir == null || coreRingDir != side) {
                    quadsList.addAll(this.cores[coreDir][coreRadius - 1].func_188616_a(blockState, side, rand));
                } else {
                    quadsList.addAll(this.rings[coreRadius - 1].func_188616_a(blockState, side, rand));
                }
            }
            if (coreRadius != 8) {
                for (EnumFacing connDir : EnumFacing.field_82609_l) {
                    int idx = connDir.func_176745_a();
                    int connRadius = connections[idx];
                    if (connRadius <= 0 || connRadius != 1 && side == connDir) continue;
                    quadsList.addAll(this.sleeves[idx][connRadius - 1].func_188616_a((IBlockState)extendedBlockState, side, rand));
                }
            }
        }
        return quadsList;
    }

    protected int[] pollConnections(int coreRadius, IExtendedBlockState extendedBlockState) {
        int[] connections = new int[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connection = this.getConnectionRadius(extendedBlockState, (IUnlistedProperty<Integer>)BlockBranch.CONNECTIONS[dir.func_176745_a()]);
            connections[dir.func_176745_a()] = MathHelper.clamp(connection, 0, coreRadius);
        }
        return connections;
    }

    protected EnumFacing getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        EnumFacing sourceDir = null;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connRadius = connections[dir.func_176745_a()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(EnumFacing dir) {
        return dir.func_176745_a() >> 1;
    }

    protected int getRadius(IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)BlockBranch.RADIUS);
    }

    protected int getConnectionRadius(IExtendedBlockState iExtendedBlockState, IUnlistedProperty<Integer> whichConnection) {
        Integer connection = (Integer)iExtendedBlockState.getValue(whichConnection);
        return connection != null ? connection : 0;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkParticles;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.sleeves[0][0].func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.sleeves[0][0] instanceof IPerspectiveAwareModel) {
            Matrix4f matrix4f = (Matrix4f)((IPerspectiveAwareModel)this.sleeves[0][0]).handlePerspective(cameraTransformType).getRight();
            return Pair.of((Object)this, (Object)matrix4f);
        }
        ItemCameraTransforms itemCameraTransforms = this.sleeves[0][0].func_177552_f();
        ItemTransformVec3f itemTransformVec3f = itemCameraTransforms.func_181688_b(cameraTransformType);
        TRSRTransformation tr = new TRSRTransformation(itemTransformVec3f);
        Matrix4f mat = null;
        if (tr != null) {
            mat = tr.getMatrix();
        }
        return Pair.of((Object)this, (Object)mat);
    }
}

