/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.models.BranchModel;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.commons.io.IOUtils;

public class ModelLoaderBranch
implements ICustomModelLoader {
    public final String BRANCH_MODEL_RESOURCE_NAME = "dynamictrees:block/smartmodel/branch";
    public final String code = "#dynamictree";
    private IResourceManager resourceManager;

    public boolean accepts(ResourceLocation resourceLocation) {
        return resourceLocation.func_110623_a().endsWith("#dynamictree");
    }

    public IModel loadModel(ResourceLocation resourceLocation) {
        ModelBlock modelBlock = this.getBranchBlockModel(resourceLocation);
        return modelBlock != null ? new BranchModel(modelBlock) : ModelLoaderRegistry.getMissingModel();
    }

    protected ModelBlock getBranchBlockModel(ResourceLocation virtualLocation) {
        if (!this.accepts(virtualLocation)) {
            return null;
        }
        String path = virtualLocation.func_110623_a();
        path = path.substring(0, path.length() - "#dynamictree".length());
        ResourceLocation location = new ResourceLocation(virtualLocation.func_110624_b(), path);
        ModelBlock modelBlock = null;
        InputStreamReader reader = null;
        IResource iresource = null;
        try {
            iresource = this.resourceManager.func_110536_a(this.getModelLocation(location));
            reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
            modelBlock = ModelBlock.func_178307_a((Reader)reader);
            modelBlock.field_178317_b = location.toString();
            ModelBlock rootParent = modelBlock;
            while (rootParent.field_178315_d != null) {
                rootParent = rootParent.field_178315_d;
            }
            if (rootParent.func_178305_e() != null && rootParent.func_178305_e().toString().equals("dynamictrees:block/smartmodel/branch")) {
                return modelBlock;
            }
            return null;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(iresource);
            return null;
        }
    }

    protected ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

