/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.potion;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.inspectors.NodeDisease;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SubstanceDisease
implements ISubstanceEffect {
    @Override
    public boolean apply(World world, BlockPos rootPos) {
        Species species;
        BlockRootyDirt dirt = TreeHelper.getRootyDirt((IBlockAccess)world, rootPos);
        if (dirt != null && (species = dirt.getSpecies(world, rootPos)) != null) {
            if (world.field_72995_K) {
                TreeHelper.treeParticles(world, rootPos, EnumParticleTypes.CRIT, 8);
            } else {
                dirt.startAnalysis(world, rootPos, new MapSignal(new NodeDisease(species)));
                dirt.fertilize(world, rootPos, -15);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean update(World world, BlockPos rootPos, int deltaTicks) {
        return false;
    }

    @Override
    public String getName() {
        return "disease";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

