/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.entities.EntityLingeringEffector;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.potion.SubstanceFertilize;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DynamicTree {
    private final ResourceLocation name;
    private BlockBranch dynamicBranch;
    private IBlockState primitiveLog;
    private ItemStack primitiveLogItemStack;
    private IBlockState primitiveSapling;
    private BlockDynamicLeaves dynamicLeaves;
    private int leavesSubBlock;
    private int smotherLeavesMax = 4;
    private int lightRequirement = 13;
    protected byte defaultHydration = (byte)4;
    private IBlockState primitiveLeaves;
    private ItemStack primitiveLeavesItemStack;
    private SimpleVoxmap leafCluster;
    private ICellSolver cellSolver = Cells.deciduousSolver;
    private ItemStack stick;
    public boolean canSupportCocoa = false;
    private static final EnumFacing[] upFirst = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};

    public DynamicTree(BlockPlanks.EnumType treeType) {
        this(new ResourceLocation("dynamictrees", treeType.func_176610_l().replace("_", "")), treeType.func_176839_a());
        this.simpleVanillaSetup(treeType);
    }

    public DynamicTree(ResourceLocation name, int seq) {
        this.name = name;
        if (seq >= 0) {
            this.setDynamicLeaves(name.func_110624_b(), seq);
        }
        this.setDynamicBranch(new BlockBranch(name + "branch"));
        this.setStick(new ItemStack(Items.field_151055_y));
        this.createLeafCluster();
        this.createSpecies();
    }

    private void simpleVanillaSetup(BlockPlanks.EnumType wood) {
        switch (wood) {
            case OAK: 
            case SPRUCE: 
            case BIRCH: 
            case JUNGLE: {
                IBlockState primLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)wood);
                IBlockState primLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)wood);
                this.setPrimitiveLeaves(primLeaves, new ItemStack(primLeaves.func_177230_c(), 1, ((BlockPlanks.EnumType)primLeaves.func_177229_b((IProperty)BlockOldLeaf.field_176239_P)).func_176839_a() & 3));
                this.setPrimitiveLog(primLog, new ItemStack(primLog.func_177230_c(), 1, ((BlockPlanks.EnumType)primLog.func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176839_a() & 3));
                break;
            }
            case ACACIA: 
            case DARK_OAK: {
                IBlockState primLeaves = Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)wood);
                IBlockState primLog = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)wood);
                this.setPrimitiveLeaves(primLeaves, new ItemStack(primLeaves.func_177230_c(), 1, ((BlockPlanks.EnumType)primLeaves.func_177229_b((IProperty)BlockNewLeaf.field_176240_P)).func_176839_a() & 3));
                this.setPrimitiveLog(primLog, new ItemStack(primLog.func_177230_c(), 1, ((BlockPlanks.EnumType)primLog.func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176839_a() & 3));
            }
        }
        this.setPrimitiveSapling(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)wood));
        ModBlocks.blockBonsaiPot.setupVanillaTree(this);
        this.simpleVanillaCommonSpecies(wood);
    }

    protected void simpleVanillaCommonSpecies(BlockPlanks.EnumType wood) {
        Species commonSpecies = this.getCommonSpecies();
        commonSpecies.setDynamicSapling(ModBlocks.blockDynamicSapling.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)wood));
        commonSpecies.generateSeed();
    }

    public abstract void createSpecies();

    public abstract void registerSpecies(IForgeRegistry<Species> var1);

    public abstract Species getCommonSpecies();

    public Species getSpeciesForLocation(World access, BlockPos pos) {
        return this.getCommonSpecies();
    }

    public ISubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        if (itemStack.func_77973_b() == Items.field_151100_aR && itemStack.func_77952_i() == 15) {
            return new SubstanceFertilize().setAmount(1).setGrow(true);
        }
        if (itemStack.func_77973_b() instanceof ISubstanceEffectProvider) {
            ISubstanceEffectProvider provider = (ISubstanceEffectProvider)itemStack.func_77973_b();
            return provider.getSubstanceEffect(itemStack);
        }
        return null;
    }

    public boolean applySubstance(World world, BlockPos rootPos, BlockPos hitPos, EntityPlayer player, EnumHand hand, ItemStack itemStack) {
        ISubstanceEffect effect = this.getSubstanceEffect(itemStack);
        if (effect != null) {
            if (effect.isLingering()) {
                CompatHelper.spawnEntity(world, new EntityLingeringEffector(world, rootPos, effect));
                return true;
            }
            return effect.apply(world, rootPos);
        }
        return false;
    }

    public boolean onTreeActivated(World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos rootPos = DynamicTree.findRootNode(world, hitPos);
        if (rootPos != null) {
            if (heldItem != null && this.applySubstance(world, rootPos, hitPos, player, hand, heldItem)) {
                CompatHelper.consumePlayerItem(player, hand, heldItem);
                return true;
            }
            Species species = DynamicTree.getExactSpecies(world, hitPos);
            if (species != null) {
                species.onTreeActivated(world, rootPos, hitPos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
            }
        }
        return false;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add(this.dynamicBranch);
        return blockList;
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        Seed seed = this.getCommonSpecies().getSeed();
        if (seed != null) {
            itemList.add(seed);
        }
        return itemList;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public DynamicTree setDynamicLeaves(BlockDynamicLeaves leaves, int sub) {
        this.dynamicLeaves = leaves;
        this.leavesSubBlock = sub;
        this.dynamicLeaves.setTree(this.leavesSubBlock, this);
        return this;
    }

    protected DynamicTree setDynamicLeaves(String modid, int seq) {
        return this.setDynamicLeaves(TreeHelper.getLeavesBlockForSequence(modid, seq), seq & 3);
    }

    public BlockDynamicLeaves getDynamicLeaves() {
        return this.dynamicLeaves;
    }

    public int getDynamicLeavesSub() {
        return this.leavesSubBlock;
    }

    public IBlockState getDynamicLeavesState() {
        return this.getDynamicLeaves().func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(this.getDynamicLeavesSub()));
    }

    public IBlockState getDynamicLeavesState(int hydro) {
        return this.getDynamicLeavesState().func_177226_a((IProperty)BlockDynamicLeaves.HYDRO, (Comparable)Integer.valueOf(MathHelper.clamp(hydro, 1, 4)));
    }

    protected DynamicTree setDynamicBranch(BlockBranch gBranch) {
        this.dynamicBranch = gBranch;
        this.dynamicBranch.setTree(this);
        return this;
    }

    public BlockBranch getDynamicBranch() {
        return this.dynamicBranch;
    }

    protected DynamicTree setStick(ItemStack itemStack) {
        this.stick = itemStack;
        return this;
    }

    public ItemStack getStick(int qty) {
        return CompatHelper.setStackCount(this.stick.func_77946_l(), MathHelper.clamp(qty, 0, 64));
    }

    protected DynamicTree setPrimitiveLeaves(IBlockState primLeaves, ItemStack primLeavesStack) {
        this.primitiveLeaves = primLeaves;
        this.primitiveLeavesItemStack = primLeavesStack;
        return this;
    }

    public IBlockState getPrimitiveLeaves() {
        return this.primitiveLeaves;
    }

    public ItemStack getPrimitiveLeavesItemStack(int qty) {
        return CompatHelper.setStackCount(this.primitiveLeavesItemStack.func_77946_l(), MathHelper.clamp(qty, 0, 64));
    }

    protected DynamicTree setPrimitiveLog(IBlockState primLog, ItemStack primLogStack) {
        this.primitiveLog = primLog;
        this.primitiveLogItemStack = primLogStack;
        return this;
    }

    public IBlockState getPrimitiveLog() {
        return this.primitiveLog;
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        return CompatHelper.setStackCount(this.primitiveLogItemStack.func_77946_l(), MathHelper.clamp(qty, 0, 64));
    }

    protected DynamicTree setPrimitiveSapling(IBlockState primSapling) {
        this.primitiveSapling = primSapling;
        return this;
    }

    public IBlockState getPrimitiveSapling() {
        return this.primitiveSapling;
    }

    public static Species getExactSpecies(World world, BlockPos pos) {
        BlockPos rootPos = DynamicTree.findRootNode(world, pos);
        if (rootPos != null) {
            BlockRootyDirt rootBlock = (BlockRootyDirt)world.func_180495_p(rootPos).func_177230_c();
            return rootBlock.getSpecies(world, rootPos);
        }
        return null;
    }

    public static BlockPos findRootNode(World world, BlockPos pos) {
        ITreePart treePart = TreeHelper.getSafeTreePart((IBlockAccess)world, pos);
        if (treePart.isRootNode()) {
            return pos;
        }
        if (treePart.isBranch()) {
            MapSignal signal = treePart.analyse(world, pos, null, new MapSignal());
            if (signal.found) {
                return signal.root;
            }
        }
        return null;
    }

    public ICell getCellForBranch(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, BlockBranch branch) {
        return branch.getRadius(blockState) == 1 ? Cells.branchCell : Cells.nullCell;
    }

    @SideOnly(value=Side.CLIENT)
    public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world != null && pos != null) {
            return BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos);
        }
        return ColorizerFoliage.func_77468_c();
    }

    public void setSmotherLeavesMax(int smotherLeavesMax) {
        this.smotherLeavesMax = smotherLeavesMax;
    }

    public int getSmotherLeavesMax() {
        return this.smotherLeavesMax;
    }

    public int getLightRequirement() {
        return this.lightRequirement;
    }

    public byte getDefaultHydration() {
        return this.defaultHydration;
    }

    public void setCellSolver(ICellSolver solver) {
        this.cellSolver = solver;
    }

    public ICellSolver getCellSolver() {
        return this.cellSolver;
    }

    public void setLeafCluster(SimpleVoxmap leafCluster) {
        this.leafCluster = leafCluster;
    }

    public SimpleVoxmap getLeafCluster() {
        return this.leafCluster;
    }

    public void createLeafCluster() {
        this.leafCluster = new SimpleVoxmap(5, 4, 5, new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 3, 4, 3, 1, 1, 4, 0, 4, 1, 1, 3, 4, 3, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 2, 3, 2, 1, 1, 3, 4, 3, 1, 1, 2, 3, 2, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 1, 2));
    }

    public byte getLeafClusterPoint(BlockPos twigPos, BlockPos leafPos) {
        return this.leafCluster.getVoxel(twigPos, leafPos);
    }

    public boolean isCompatibleDynamicLeaves(IBlockAccess blockAccess, BlockPos pos) {
        IBlockState state = blockAccess.func_180495_p(pos);
        ITreePart treePart = TreeHelper.getTreePart(state);
        if (treePart != null && treePart instanceof BlockDynamicLeaves) {
            return this == ((BlockDynamicLeaves)treePart).getTree(state);
        }
        return false;
    }

    public boolean isCompatibleDynamicLeaves(Block leaves, int sub) {
        return leaves == this.getDynamicLeaves() && sub == this.getDynamicLeavesSub();
    }

    public boolean isCompatibleVanillaLeaves(IBlockAccess blockAccess, BlockPos pos) {
        Block otherBlock;
        IBlockState primState = this.getPrimitiveLeaves();
        IBlockState otherState = blockAccess.func_180495_p(pos);
        Block primBlock = primState.func_177230_c();
        if (primBlock == (otherBlock = otherState.func_177230_c())) {
            return (primBlock.func_176201_c(primState) & 3) == (otherBlock.func_176201_c(otherState) & 3);
        }
        return false;
    }

    public boolean isCompatibleGenericLeaves(IBlockAccess blockAccess, BlockPos pos) {
        return this.isCompatibleDynamicLeaves(blockAccess, pos) || this.isCompatibleVanillaLeaves(blockAccess, pos);
    }

    public ICell getCellForLeaves(int hydro) {
        return Cells.normalCells[hydro];
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random) {
        if (radius <= 1) {
            for (EnumFacing dir : upFirst) {
                if (!this.getDynamicLeaves().growLeaves(world, this, pos.func_177972_a(dir), 0)) continue;
                return false;
            }
        }
        world.func_175698_g(pos);
        return true;
    }

    public BlockBonsaiPot getBonzaiPot() {
        return ModBlocks.blockBonsaiPot;
    }

    public String toString() {
        return this.getName().toString();
    }
}

