/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.cells.CellDarkOakLeaf;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TreeDarkOak
extends DynamicTree {
    Species species;
    protected static final ICell[] darkOakLeafCells = new ICell[]{Cells.nullCell, new CellDarkOakLeaf(1), new CellDarkOakLeaf(2), new CellDarkOakLeaf(3), new CellDarkOakLeaf(4)};

    public TreeDarkOak() {
        super(BlockPlanks.EnumType.DARK_OAK);
        this.setCellSolver(Cells.darkOakSolver);
        this.setSmotherLeavesMax(3);
    }

    @Override
    public void createSpecies() {
        this.species = new SpeciesDarkOak((DynamicTree)this);
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        speciesRegistry.register((IForgeRegistryEntry)this.species);
    }

    @Override
    public Species getCommonSpecies() {
        return this.species;
    }

    @Override
    public ICell getCellForLeaves(int hydro) {
        return darkOakLeafCells[hydro];
    }

    @Override
    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random) {
        if (super.rot(world, pos, neighborCount, radius, random)) {
            if (radius > 2 && TreeHelper.isRootyDirt((IBlockAccess)world, pos.func_177977_b()) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 6) {
                world.func_175656_a(pos, ModBlocks.blockStates.redMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }

    @Override
    public void createLeafCluster() {
        this.setLeafCluster(new SimpleVoxmap(7, 5, 7, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 2, 2, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 1, 2, 4, 0, 4, 2, 1, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 2, 2, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 2, 2, 2, 1, 0, 0, 1, 2, 4, 2, 1, 0, 0, 1, 2, 2, 2, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(3, 1, 3)));
    }

    public class SpeciesDarkOak
    extends Species {
        SpeciesDarkOak(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.35f, 18.0f, 6, 8, 0.8f);
            this.setSoilLongevity(14);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.MUSHROOM, 1.25f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesDarkOak.isOneOfBiomes(biome, Biomes.field_150585_R);
        }

        @Override
        public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
            Random rand;
            Random random = rand = blockAccess instanceof World ? ((World)blockAccess).field_73012_v : new Random();
            if (rand.nextInt(chance) == 0) {
                drops.add(new ItemStack(Items.field_151034_e, 1, 0));
            }
            return drops;
        }

        @Override
        public int getLowestBranchHeight(World world, BlockPos pos) {
            return (int)((float)super.getLowestBranchHeight(world, pos) * this.biomeSuitability(world, pos));
        }

        @Override
        public float getEnergy(World world, BlockPos pos) {
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos);
        }

        @Override
        public float getGrowthRate(World world, BlockPos pos) {
            return super.getGrowthRate(world, pos) * this.biomeSuitability(world, pos);
        }

        @Override
        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            float energyRatio;
            float spreadPush;
            if (signal.numTurns >= 1) {
                probMap[EnumFacing.UP.func_176745_a()] = 0;
                probMap[EnumFacing.DOWN.func_176745_a()] = 0;
            }
            spreadPush = (spreadPush = (energyRatio = (float)signal.delta.func_177956_o() / this.getEnergy(world, pos)) * energyRatio * energyRatio * 4.0f) < 1.0f ? 1.0f : spreadPush;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                int n = dir.ordinal();
                probMap[n] = (int)((float)probMap[n] * spreadPush);
            }
            return probMap;
        }
    }
}

