/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.genfeatures.GenFeatureUndergrowth;
import com.ferreusveritas.dynamictrees.genfeatures.GenFeatureVine;
import com.ferreusveritas.dynamictrees.inspectors.NodeFruitCocoa;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.List;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TreeJungle
extends DynamicTree {
    Species species;

    public TreeJungle() {
        super(BlockPlanks.EnumType.JUNGLE);
        this.canSupportCocoa = true;
    }

    @Override
    public int getLightRequirement() {
        return 12;
    }

    @Override
    public void createSpecies() {
        this.species = new SpeciesJungle((DynamicTree)this);
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        speciesRegistry.register((IForgeRegistryEntry)this.species);
    }

    @Override
    public Species getCommonSpecies() {
        return this.species;
    }

    @Override
    public boolean onTreeActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockBranch branch;
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 3 && (branch = TreeHelper.getBranch((IBlockAccess)world, pos)) != null && branch.getRadius((IBlockAccess)world, pos) == 8) {
            if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
                pos = pos.func_177972_a(side);
            }
            if (world.func_175623_d(pos)) {
                IBlockState cocoaState = ModBlocks.blockFruitCocoa.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, heldItem);
                EnumFacing facing = (EnumFacing)cocoaState.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                world.func_180501_a(pos, ModBlocks.blockFruitCocoa.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 2);
                if (!player.field_71075_bZ.field_75098_d) {
                    CompatHelper.shrinkStack(heldItem, 1);
                }
                return true;
            }
        }
        return super.onTreeActivated(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public class SpeciesJungle
    extends Species {
        GenFeatureVine vineGen;
        GenFeatureUndergrowth underGen;

        SpeciesJungle(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.2f, 28.0f, 3, 2, 1.0f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.15f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.2f);
            this.envFactor(BiomeDictionary.Type.HOT, 1.1f);
            this.envFactor(BiomeDictionary.Type.WET, 1.1f);
            this.vineGen = new GenFeatureVine(this);
            this.underGen = new GenFeatureUndergrowth(this);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return CompatHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE);
        }

        @Override
        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            int treeHash = this.coordHashCode(signal.rootPos);
            int posHash = this.coordHashCode(pos);
            probMap[0] = 0;
            probMap[1] = signal.isInTrunk() ? this.getUpProbability() : 0;
            probMap[5] = 0;
            probMap[4] = 0;
            probMap[3] = 0;
            probMap[2] = 0;
            int sideTurn = !signal.isInTrunk() || signal.isInTrunk() && (signal.numSteps + treeHash) % 5 == 0 && radius > 1 ? 2 : 0;
            int height = 18 + treeHash % 7829 % 8;
            if (signal.delta.func_177956_o() < height) {
                probMap[2 + posHash % 4] = sideTurn;
            } else {
                probMap[5] = 2;
                probMap[4] = 2;
                probMap[3] = 2;
                probMap[2] = 2;
                probMap[1] = 2;
            }
            probMap[originDir.ordinal()] = 0;
            int n = signal.dir.ordinal();
            probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
            return probMap;
        }

        @Override
        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy = 4.0f;
            }
            return newDir;
        }

        private int coordHashCode(BlockPos pos) {
            int hash = (pos.func_177958_n() * 9973 ^ pos.func_177956_o() * 8287 ^ pos.func_177952_p() * 9721) >> 1;
            return hash & 0xFFFF;
        }

        @Override
        public float getEnergy(World world, BlockPos pos) {
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos);
        }

        @Override
        public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, boolean worldGen) {
            super.postGeneration(world, rootPos, biome, radius, endPoints, worldGen);
            if (world.field_73012_v.nextInt() % 8 == 0) {
                this.addCocoa(world, rootPos, true);
            }
            if (worldGen) {
                BlockPos treePos = rootPos.func_177984_a();
                this.vineGen.setQuantity(endPoints.size()).setMaxLength(20).gen(world, treePos, endPoints);
                this.underGen.setRadius(radius).gen(world, treePos, endPoints);
            }
        }

        @Override
        public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int soilLife, boolean rapid) {
            super.postGrow(world, rootPos, treePos, soilLife, rapid);
            if (soilLife == 0 && world.field_73012_v.nextInt() % 16 == 0) {
                this.addCocoa(world, rootPos, false);
            }
            return true;
        }

        private void addCocoa(World world, BlockPos rootPos, boolean worldGen) {
            TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(new NodeFruitCocoa().setWorldGen(worldGen)));
        }
    }
}

