/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.genfeatures.GenFeatureVine;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TreeOak
extends DynamicTree {
    Species commonSpecies;
    Species swampSpecies;
    Species appleSpecies;

    public TreeOak() {
        super(BlockPlanks.EnumType.OAK);
    }

    @Override
    public void createSpecies() {
        this.commonSpecies = new SpeciesOak((DynamicTree)this);
        this.swampSpecies = new SpeciesSwampOak((DynamicTree)this);
        this.appleSpecies = new SpeciesAppleOak((DynamicTree)this);
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        speciesRegistry.register((IForgeRegistryEntry)this.commonSpecies);
        speciesRegistry.register((IForgeRegistryEntry)this.swampSpecies);
        speciesRegistry.register((IForgeRegistryEntry)this.appleSpecies);
    }

    @Override
    public Species getCommonSpecies() {
        return this.commonSpecies;
    }

    @Override
    public Species getSpeciesForLocation(World world, BlockPos pos) {
        if (CompatHelper.biomeHasType(world.func_180494_b(pos), BiomeDictionary.Type.SWAMP)) {
            return this.swampSpecies;
        }
        return this.getCommonSpecies();
    }

    @Override
    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random) {
        if (super.rot(world, pos, neighborCount, radius, random)) {
            if (radius > 4 && TreeHelper.isRootyDirt((IBlockAccess)world, pos.func_177977_b()) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                world.func_175656_a(pos.func_177977_b(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }

    public class SpeciesAppleOak
    extends Species {
        public SpeciesAppleOak(DynamicTree treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), "apple"), treeFamily);
            this.setBasicGrowingParameters(0.4f, 10.0f, 1, 4, 0.7f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return biome == Biomes.field_76772_c;
        }

        @Override
        public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
            return TreeOak.this.commonSpecies.getDrops(blockAccess, pos, chance, drops);
        }

        @Override
        public void postGeneration(World world, BlockPos pos, Biome biome, int radius, List<BlockPos> endPoints, boolean worldGen) {
            super.postGeneration(world, pos, biome, radius, endPoints, worldGen);
        }
    }

    public class SpeciesSwampOak
    extends Species {
        GenFeatureVine vineGen;

        SpeciesSwampOak(DynamicTree treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), treeFamily.getName().func_110623_a() + "swamp"), treeFamily);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.vineGen = new GenFeatureVine(this).setMaxLength(7).setVerSpread(30.0f).setRayDistance(6.0f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesSwampOak.isOneOfBiomes(biome, Biomes.field_76780_h);
        }

        @Override
        public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
            BlockPos down;
            Biome biome;
            if (soilBlockState.func_177230_c() == Blocks.field_150355_j && CompatHelper.biomeHasType(biome = world.func_180494_b(pos), BiomeDictionary.Type.SWAMP) && this.isAcceptableSoil(world, down = pos.func_177977_b(), world.func_180495_p(down))) {
                return true;
            }
            return super.isAcceptableSoilForWorldgen(world, pos, soilBlockState);
        }

        @Override
        public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
            return TreeOak.this.commonSpecies.getDrops(blockAccess, pos, chance, drops);
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return TreeOak.this.commonSpecies.getSeedStack(qty);
        }

        @Override
        public Seed getSeed() {
            return TreeOak.this.commonSpecies.getSeed();
        }

        @Override
        public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, boolean worldGen) {
            super.postGeneration(world, rootPos, biome, radius, endPoints, worldGen);
            this.vineGen.setQuantity(5).gen(world, rootPos.func_177984_a(), endPoints);
        }
    }

    public class SpeciesOak
    extends Species {
        SpeciesOak(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesOak.isOneOfBiomes(biome, Biomes.field_76767_f, Biomes.field_76785_t);
        }

        @Override
        public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
            Random rand;
            Random random = rand = blockAccess instanceof World ? ((World)blockAccess).field_73012_v : new Random();
            if (rand.nextInt(chance) == 0) {
                drops.add(new ItemStack(Items.field_151034_e, 1, 0));
            }
            return drops;
        }
    }
}

