/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.cells.CellConiferBranch;
import com.ferreusveritas.dynamictrees.cells.CellConiferLeaf;
import com.ferreusveritas.dynamictrees.cells.CellConiferTopBranch;
import com.ferreusveritas.dynamictrees.genfeatures.GenFeaturePodzol;
import com.ferreusveritas.dynamictrees.inspectors.NodeFindEnds;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TreeSpruce
extends DynamicTree {
    Species species;
    protected static final ICell spruceBranch = new CellConiferBranch();
    protected static final ICell spruceTopBranch = new CellConiferTopBranch();
    protected static final ICell[] spruceLeafCells = new ICell[]{Cells.nullCell, new CellConiferLeaf(1), new CellConiferLeaf(2), new CellConiferLeaf(3), new CellConiferLeaf(4)};

    public TreeSpruce() {
        super(BlockPlanks.EnumType.SPRUCE);
        this.setCellSolver(Cells.coniferSolver);
        this.setSmotherLeavesMax(3);
    }

    @Override
    public void createSpecies() {
        this.species = new SpeciesSpruce((DynamicTree)this);
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        speciesRegistry.register((IForgeRegistryEntry)this.species);
    }

    @Override
    public Species getCommonSpecies() {
        return this.species;
    }

    @Override
    public ICell getCellForBranch(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, BlockBranch branch) {
        if (branch.getRadius(blockState) == 1) {
            return blockAccess.func_180495_p(pos.func_177977_b()).func_177230_c() == branch ? spruceTopBranch : spruceBranch;
        }
        return Cells.nullCell;
    }

    @Override
    public ICell getCellForLeaves(int hydro) {
        return spruceLeafCells[hydro];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ColorizerFoliage.func_77466_a();
    }

    @Override
    public void createLeafCluster() {
        this.setLeafCluster(new SimpleVoxmap(5, 2, 5, new byte[]{0, 0, 1, 0, 0, 0, 1, 2, 1, 0, 1, 2, 0, 2, 1, 0, 1, 2, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 0, 2)));
    }

    public class SpeciesSpruce
    extends Species {
        GenFeaturePodzol podzolGen;

        SpeciesSpruce(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.25f, 16.0f, 3, 3, 0.9f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
            this.podzolGen = new GenFeaturePodzol();
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return CompatHelper.biomeHasType(biome, BiomeDictionary.Type.CONIFEROUS);
        }

        @Override
        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            probMap[1] = signal.isInTrunk() ? this.getUpProbability() : 0;
            probMap[5] = !signal.isInTrunk() || signal.isInTrunk() && signal.numSteps % 2 == 1 && radius > 1 ? 2 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            probMap[originDir.ordinal()] = 0;
            int n = signal.dir.ordinal();
            probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
            return probMap;
        }

        @Override
        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy /= 3.0f;
            }
            return newDir;
        }

        @Override
        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_82737_E() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(this.coordHashCode(pos.func_177981_b(month)) % 5);
        }

        public int coordHashCode(BlockPos pos) {
            int hash = (pos.func_177958_n() * 9973 ^ pos.func_177956_o() * 8287 ^ pos.func_177952_p() * 9721) >> 1;
            return hash & 0xFFFF;
        }

        @Override
        public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int soilLife, boolean rapid) {
            if (ModConfigs.podzolGen) {
                NodeFindEnds endFinder = new NodeFindEnds();
                TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(endFinder));
                this.podzolGen.gen(world, treePos, endFinder.getEnds());
            }
            return true;
        }
    }
}

