/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.substances.IEmptiable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class CompatHelper {
    public static boolean spawnEntity(World world, Entity entity) {
        return world.func_72838_d(entity);
    }

    public static World getEntityWorld(Entity entity) {
        return entity.field_70170_p;
    }

    public static ItemStack getEntityItem(EntityItem entityItem) {
        return entityItem.func_92059_d();
    }

    public static boolean biomeHasType(Biome biome, BiomeDictionary.Type type) {
        return BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type);
    }

    public static int getBiomeTreesPerChunk(Biome biome) {
        return biome.field_76760_I.field_76832_z;
    }

    public static int getStackCount(ItemStack stack) {
        return CompatHelper.isValid(stack) ? stack.field_77994_a : 0;
    }

    public static ItemStack setStackCount(ItemStack stack, int size) {
        if (CompatHelper.isValid(stack)) {
            stack.field_77994_a = size;
            return stack;
        }
        return CompatHelper.emptyStack();
    }

    public static ItemStack growStack(ItemStack stack, int quantity) {
        if (CompatHelper.isValid(stack)) {
            stack.field_77994_a += quantity;
            return stack;
        }
        return CompatHelper.emptyStack();
    }

    public static ItemStack shrinkStack(ItemStack stack, int quantity) {
        return CompatHelper.growStack(stack, -quantity);
    }

    public static ItemStack emptyStack() {
        return null;
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && stack != CompatHelper.emptyStack();
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return CompatHelper.getStackCount(stack) == 0;
    }

    public static void consumePlayerItem(EntityPlayer player, EnumHand hand, ItemStack heldItem) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (heldItem.func_77973_b() instanceof IEmptiable) {
                IEmptiable emptiable = (IEmptiable)heldItem.func_77973_b();
                player.func_184611_a(hand, emptiable.getEmptyContainer());
            } else if (heldItem.func_77973_b() == Items.field_151068_bn) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            } else {
                CompatHelper.shrinkStack(heldItem, 1);
            }
        }
    }
}

