/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.google.common.collect.AbstractIterator;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class SimpleVoxmap {
    private byte[] data;
    private boolean[] touched;
    private int lenX;
    private int lenY;
    private int lenZ;
    BlockPos center = new BlockPos(0, 0, 0);

    public SimpleVoxmap(int lenX, int lenY, int lenZ) {
        this.data = new byte[lenX * lenY * lenZ];
        this.touched = new boolean[lenY];
        this.lenX = lenX;
        this.lenY = lenY;
        this.lenZ = lenZ;
    }

    public SimpleVoxmap(int lenX, int lenY, int lenZ, byte[] extData) {
        this.data = Arrays.copyOf(extData, lenX * lenY * lenZ);
        this.touched = new boolean[lenY];
        for (int y = 0; y < lenY; ++y) {
            this.touched[y] = true;
        }
        this.lenX = lenX;
        this.lenY = lenY;
        this.lenZ = lenZ;
    }

    public SimpleVoxmap(SimpleVoxmap vmp) {
        this(vmp.getLenX(), vmp.getLenY(), vmp.getLenZ(), vmp.data);
    }

    public SimpleVoxmap setMapAndCenter(BlockPos mapPos, BlockPos centerPos) {
        this.setCenter(centerPos);
        this.center = this.center.func_177973_b((Vec3i)mapPos);
        return this;
    }

    public SimpleVoxmap setMap(BlockPos mapPos) {
        this.center = this.center.func_177973_b((Vec3i)mapPos);
        return this;
    }

    public SimpleVoxmap setCenter(BlockPos centerPos) {
        this.center = centerPos;
        return this;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLenX() {
        return this.lenX;
    }

    public int getLenY() {
        return this.lenY;
    }

    public int getLenZ() {
        return this.lenZ;
    }

    public SimpleVoxmap clear() {
        this.data = new byte[this.data.length];
        this.touched = new boolean[this.touched.length];
        return this;
    }

    public static final byte max(byte a, byte b) {
        return a >= b ? a : b;
    }

    public void BlitMax(BlockPos pos, SimpleVoxmap src) {
        for (int iy = 0; iy < src.getLenY(); ++iy) {
            int srcY = iy - src.center.func_177956_o();
            int dstY = pos.func_177956_o() + srcY;
            this.setYTouched(dstY);
            for (int iz = 0; iz < src.getLenZ(); ++iz) {
                int srcZ = iz - src.center.func_177952_p();
                int dstZ = pos.func_177952_p() + srcZ;
                for (int ix = 0; ix < src.getLenX(); ++ix) {
                    int srcX = ix - src.center.func_177958_n();
                    int dstX = pos.func_177958_n() + srcX;
                    byte srcValue = src.getVoxel(srcX, srcY, srcZ);
                    byte dstValue = this.getVoxel(dstX, dstY, dstZ);
                    this.setVoxel(dstX, dstY, dstZ, SimpleVoxmap.max(srcValue, dstValue));
                }
            }
        }
    }

    public void BlitClear(BlockPos pos, SimpleVoxmap src) {
        for (int iy = 0; iy < src.getLenY(); ++iy) {
            int srcY = iy - src.center.func_177956_o();
            int dstY = pos.func_177956_o() + srcY;
            this.setYTouched(dstY);
            for (int iz = 0; iz < src.getLenZ(); ++iz) {
                int srcZ = iz - src.center.func_177952_p();
                int dstZ = pos.func_177952_p() + srcZ;
                for (int ix = 0; ix < src.getLenX(); ++ix) {
                    int srcX = ix - src.center.func_177958_n();
                    int dstX = pos.func_177958_n() + srcX;
                    byte srcValue = src.getVoxel(srcX, srcY, srcZ);
                    if (srcValue <= 0) continue;
                    this.setVoxel(dstX, dstY, dstZ, (byte)0);
                }
            }
        }
    }

    private int calcPos(int x, int y, int z) {
        return y * this.lenX * this.lenZ + z * this.lenX + x;
    }

    public void setVoxel(BlockPos pos, byte value) {
        this.setVoxel(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), value);
    }

    public void setVoxel(int x, int y, int z, byte value) {
        if (this.testBounds(x += this.center.func_177958_n(), y += this.center.func_177956_o(), z += this.center.func_177952_p())) {
            if (value != 0) {
                this.setYTouched(y);
            }
            this.data[this.calcPos((int)x, (int)y, (int)z)] = value;
        }
    }

    public byte getVoxel(BlockPos relPos, BlockPos pos) {
        return this.getVoxel(pos.func_177958_n() - relPos.func_177958_n(), pos.func_177956_o() - relPos.func_177956_o(), pos.func_177952_p() - relPos.func_177952_p());
    }

    public byte getVoxel(BlockPos pos) {
        return this.getVoxel(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public byte getVoxel(int x, int y, int z) {
        if (this.isYTouched(y)) {
            return this.testBounds(x += this.center.func_177958_n(), y += this.center.func_177956_o(), z += this.center.func_177952_p()) ? this.data[this.calcPos(x, y, z)] : (byte)0;
        }
        return 0;
    }

    private boolean testBounds(int x, int y, int z) {
        return x >= 0 && x < this.lenX && y >= 0 && y < this.lenY && z >= 0 && z < this.lenZ;
    }

    public boolean isYTouched(int y) {
        return (y += this.center.func_177956_o()) >= 0 && y < this.lenY && this.touched[y];
    }

    public void setYTouched(int y) {
        if ((y += this.center.func_177956_o()) >= 0 && y < this.lenY) {
            this.touched[y] = true;
        }
    }

    public Iterable<Cell> getAllNonZeroCells() {
        return this.getAllNonZeroCells((byte)-1);
    }

    public Iterable<Cell> getAllNonZeroCells(final byte mask) {
        return new Iterable<Cell>(){

            @Override
            public Iterator<Cell> iterator() {
                return new AbstractIterator<Cell>(){
                    private int x = 0;
                    private int y = 0;
                    private int z = 0;

                    protected Cell computeNext() {
                        while (true) {
                            int pos = SimpleVoxmap.this.calcPos(this.x, this.y, this.z);
                            BlockPos dPos = new BlockPos(this.x, this.y, this.z);
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                this.x = 0;
                                this.z = 0;
                                ++this.y;
                            }
                            if (this.y >= SimpleVoxmap.this.lenY) {
                                return (Cell)this.endOfData();
                            }
                            if (SimpleVoxmap.this.touched[this.y]) {
                                byte value = (byte)(SimpleVoxmap.this.data[pos] & mask);
                                if (value <= 0) continue;
                                return new Cell(value, dPos.func_177973_b((Vec3i)SimpleVoxmap.this.center));
                            }
                            ++this.y;
                        }
                    }
                };
            }
        };
    }

    public Iterable<Cell> getAllNonZeroCellsFromTop() {
        return this.getAllNonZeroCellsFromTop((byte)-1);
    }

    public Iterable<Cell> getAllNonZeroCellsFromTop(final byte mask) {
        return new Iterable<Cell>(){

            @Override
            public Iterator<Cell> iterator() {
                return new AbstractIterator<Cell>(){
                    private int x = 0;
                    private int y;
                    private int z;
                    {
                        this.y = SimpleVoxmap.this.lenY - 1;
                        this.z = 0;
                    }

                    protected Cell computeNext() {
                        while (true) {
                            int pos = SimpleVoxmap.this.calcPos(this.x, this.y, this.z);
                            BlockPos dPos = new BlockPos(this.x, this.y, this.z);
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                this.x = 0;
                                this.z = 0;
                                --this.y;
                            }
                            if (this.y < 0) {
                                return (Cell)this.endOfData();
                            }
                            if (SimpleVoxmap.this.touched[this.y]) {
                                byte value = (byte)(SimpleVoxmap.this.data[pos] & mask);
                                if (value <= 0) continue;
                                return new Cell(value, dPos.func_177973_b((Vec3i)SimpleVoxmap.this.center));
                            }
                            --this.y;
                        }
                    }
                };
            }
        };
    }

    public Iterable<BlockPos> getAllNonZero() {
        return this.getAllNonZero((byte)-1);
    }

    public Iterable<BlockPos> getAllNonZero(final byte mask) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int x = 0;
                    private int y = 0;
                    private int z = 0;

                    protected BlockPos computeNext() {
                        while (true) {
                            int pos = SimpleVoxmap.this.calcPos(this.x, this.y, this.z);
                            BlockPos dPos = new BlockPos(this.x, this.y, this.z);
                            if (this.x < SimpleVoxmap.this.lenX - 1) {
                                ++this.x;
                            } else if (this.z < SimpleVoxmap.this.lenZ - 1) {
                                this.x = 0;
                                ++this.z;
                            } else {
                                this.x = 0;
                                this.z = 0;
                                ++this.y;
                            }
                            if (this.y >= SimpleVoxmap.this.lenY) {
                                return (BlockPos)this.endOfData();
                            }
                            if (SimpleVoxmap.this.touched[this.y]) {
                                if ((SimpleVoxmap.this.data[pos] & mask) <= 0) continue;
                                return dPos.func_177973_b((Vec3i)SimpleVoxmap.this.center);
                            }
                            ++this.y;
                        }
                    }
                };
            }
        };
    }

    public void print() {
        for (int y = 0; y < this.lenY; ++y) {
            String buffer;
            for (int z = 0; z < this.lenZ; ++z) {
                buffer = "";
                for (int x = 0; x < this.lenX; ++x) {
                    byte b = this.getVoxel(x - this.center.func_177958_n(), y - this.center.func_177956_o(), z - this.center.func_177952_p());
                    buffer = (b & 0x20) != 0 ? buffer + "B" : ((b & 0x10) != 0 ? buffer + "T" : buffer + Integer.toHexString(b & 0xF));
                }
                System.out.println(buffer);
            }
            buffer = "";
            for (int k = 0; k < this.lenX; ++k) {
                buffer = buffer + "-";
            }
            System.out.println(buffer);
        }
    }

    public class Cell {
        private byte value;
        private BlockPos pos;

        public Cell(byte value, BlockPos pos) {
            this.value = value;
            this.pos = pos;
        }

        public byte getValue() {
            return this.value;
        }

        public BlockPos getPos() {
            return this.pos;
        }
    }
}

