/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDensityProvider;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeSpeciesSelector;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.worldgen.DefaultBiomeDensityProvider;
import com.ferreusveritas.dynamictrees.worldgen.DefaultBiomeTreeSelector;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BiomeTreeHandler
implements IBiomeDensityProvider,
IBiomeSpeciesSelector {
    private ArrayList<IBiomeSpeciesSelector> biomeTreeSelectors = new ArrayList();
    private ArrayList<IBiomeDensityProvider> biomeDensityProvider = new ArrayList();

    public BiomeTreeHandler() {
        this.addTreeSelector(new DefaultBiomeTreeSelector());
        this.addDensityProvider(new DefaultBiomeDensityProvider());
    }

    public void addTreeSelector(IBiomeSpeciesSelector treeSelector) {
        this.biomeTreeSelectors.add(treeSelector);
        this.biomeTreeSelectors.sort(new Comparator<IBiomeSpeciesSelector>(){

            @Override
            public int compare(IBiomeSpeciesSelector sel1, IBiomeSpeciesSelector sel2) {
                return sel2.getPriority() - sel1.getPriority();
            }
        });
    }

    public void addDensityProvider(IBiomeDensityProvider densityProvider) {
        this.biomeDensityProvider.add(densityProvider);
        this.biomeDensityProvider.sort(new Comparator<IBiomeDensityProvider>(){

            @Override
            public int compare(IBiomeDensityProvider sel1, IBiomeDensityProvider sel2) {
                return sel2.getPriority() - sel1.getPriority();
            }
        });
    }

    @Override
    public void init() {
        for (IBiomeSpeciesSelector selector : this.biomeTreeSelectors) {
            selector.init();
        }
    }

    @Override
    public IBiomeSpeciesSelector.Decision getSpecies(World world, Biome biome, BlockPos pos, IBlockState dirt, Random random) {
        for (IBiomeSpeciesSelector selector : this.biomeTreeSelectors) {
            IBiomeSpeciesSelector.Decision decision = selector.getSpecies(world, biome, pos, dirt, random);
            if (decision == null || !decision.isHandled()) continue;
            return decision;
        }
        return new IBiomeSpeciesSelector.Decision(null);
    }

    @Override
    public double getDensity(Biome biome, double noiseDensity, Random random) {
        for (IBiomeDensityProvider provider : this.biomeDensityProvider) {
            double density = provider.getDensity(biome, noiseDensity, random);
            if (!(density >= 0.0)) continue;
            return MathHelper.clamp(density, 0.0, 1.0);
        }
        return noiseDensity;
    }

    @Override
    public IBiomeDensityProvider.EnumChance chance(Biome biome, Species species, int radius, Random random) {
        for (IBiomeDensityProvider provider : this.biomeDensityProvider) {
            IBiomeDensityProvider.EnumChance c = provider.chance(biome, species, radius, random);
            if (c == IBiomeDensityProvider.EnumChance.UNHANDLED) continue;
            return c;
        }
        return IBiomeDensityProvider.EnumChance.OK;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public String getName() {
        return "core";
    }
}

