/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.util.Circle;
import java.util.ArrayList;
import java.util.Arrays;

public class ChunkCircleSet {
    private byte[] circleData;
    boolean generated = false;

    ChunkCircleSet() {
        this.circleData = new byte[16];
    }

    ChunkCircleSet(byte[] data) {
        this.generated = true;
        this.circleData = data != null && data.length == 16 ? Arrays.copyOf(data, 16) : new byte[16];
    }

    public ArrayList<Circle> getCircles(ArrayList<Circle> circles, int chunkX, int chunkZ) {
        for (int tile = 0; tile < 16; ++tile) {
            byte cd = this.circleData[tile];
            if (cd == 0) continue;
            if ((cd & 0x80) != 0) {
                int flip = (cd | cd << 1) & 3;
                circles.add(ChunkCircleSet.unpackCircleData(tile, 0x10 ^ flip, chunkX, chunkZ));
                circles.add(ChunkCircleSet.unpackCircleData(tile, 0x1F ^ flip, chunkX, chunkZ));
                continue;
            }
            if ((cd & 0x70) == 0) continue;
            circles.add(ChunkCircleSet.unpackCircleData(tile, cd, chunkX, chunkZ));
        }
        return circles;
    }

    public void clearCircles() {
        Arrays.fill(this.circleData, (byte)0);
    }

    public ArrayList<Circle> addCircles(ArrayList<Circle> circles) {
        this.clearCircles();
        for (Circle c : circles) {
            this.addCircle(c);
        }
        return circles;
    }

    private static final Circle unpackCircleData(int tile, int circleData, int chunkX, int chunkZ) {
        int radius = ChunkCircleSet.getRadiusFromCircleData(circleData);
        int x = tile << 2 & 0xC;
        int z = tile & 0xC;
        return new Circle(chunkX << 4 | x | circleData >> 2 & 3, chunkZ << 4 | z | circleData & 3, radius, true);
    }

    private static final int getRadiusFromCircleData(int circleData) {
        return (circleData >> 4 & 7) + 1;
    }

    private static final byte buildCircleData(Circle c) {
        return (byte)((c.radius - 1 & 7) << 4 | (c.x & 3) << 2 | c.z & 3);
    }

    private static final int calcTileNum(Circle c) {
        return c.z & 0xC | (c.x & 0xC) >> 2;
    }

    boolean addCircle(Circle c) {
        if (c.radius >= 2 && c.radius <= 8) {
            int tile = ChunkCircleSet.calcTileNum(c);
            byte cd = this.circleData[tile];
            if (cd != 0) {
                if (c.radius == 2 && ChunkCircleSet.getRadiusFromCircleData(cd) == 2) {
                    int oldCirclePos = cd & 0xF;
                    int newCirclePos = (c.x & 3) << 2 | c.z & 3;
                    switch (oldCirclePos << 4 | newCirclePos) {
                        case 15: 
                        case 240: {
                            this.circleData[tile] = -128;
                            return true;
                        }
                        case 60: 
                        case 195: {
                            this.circleData[tile] = -127;
                            return true;
                        }
                    }
                }
            } else {
                this.circleData[tile] = ChunkCircleSet.buildCircleData(c);
                return true;
            }
        }
        return false;
    }

    public byte[] getCircleData() {
        return this.circleData;
    }

    public void setCircleData(byte[] circleData) {
        this.circleData = Arrays.copyOf(circleData, 16);
    }
}

