/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeSpeciesSelector;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHills;
import net.minecraftforge.common.BiomeDictionary;

public class DefaultBiomeTreeSelector
implements IBiomeSpeciesSelector {
    private Species oak;
    private Species birch;
    private Species spruce;
    private Species acacia;
    private Species jungle;
    private Species darkoak;
    private Species oakswamp;
    private StaticDecision staticOakDecision;
    private StaticDecision staticSpruceDecision;
    private StaticDecision staticBirchDecision;
    private StaticDecision staticDarkOakDecision;
    HashMap<Integer, ITreeSelector> fastTreeLookup = new HashMap();

    @Override
    public void init() {
        this.oak = TreeRegistry.findSpeciesSloppy("oak");
        this.birch = TreeRegistry.findSpeciesSloppy("birch");
        this.spruce = TreeRegistry.findSpeciesSloppy("spruce");
        this.acacia = TreeRegistry.findSpeciesSloppy("acacia");
        this.jungle = TreeRegistry.findSpeciesSloppy("jungle");
        this.darkoak = TreeRegistry.findSpeciesSloppy("darkoak");
        this.oakswamp = TreeRegistry.findSpeciesSloppy("oakswamp");
        this.staticOakDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.oak));
        this.staticSpruceDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.spruce));
        this.staticBirchDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.birch));
        this.staticDarkOakDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.darkoak));
    }

    @Override
    public String getName() {
        return "dynamictrees:default";
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public IBiomeSpeciesSelector.Decision getSpecies(World world, Biome biome, BlockPos pos, IBlockState dirt, Random random) {
        ITreeSelector select;
        int biomeId = Biome.func_185362_a((Biome)biome);
        if (this.fastTreeLookup.containsKey(biomeId)) {
            select = this.fastTreeLookup.get(biomeId);
        } else {
            select = biome instanceof BiomeHills ? new RandomDecision(world.field_73012_v).addSpecies(this.oak, 1).addSpecies(this.spruce, 2).end() : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.FOREST) ? (biome == Biomes.field_185432_ad || biome == Biomes.field_185433_ae ? this.staticSpruceDecision : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.CONIFEROUS) ? this.staticSpruceDecision : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SPOOKY) ? this.staticDarkOakDecision : (Species.isOneOfBiomes(biome, Biomes.field_150583_P, Biomes.field_150582_Q) ? this.staticBirchDecision : new RandomDecision(world.field_73012_v).addSpecies(this.oak, 4).addSpecies(this.birch, 1).end())))) : (biome == Biomes.field_185430_ab ? this.staticDarkOakDecision : (biome == Biomes.field_150607_aa ? this.staticOakDecision : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE) ? new StaticDecision(new IBiomeSpeciesSelector.Decision(this.jungle)) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SAVANNA) ? new StaticDecision(new IBiomeSpeciesSelector.Decision(this.acacia)) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SWAMP) ? new StaticDecision(new IBiomeSpeciesSelector.Decision(this.oakswamp)) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SANDY) ? new StaticDecision(new IBiomeSpeciesSelector.Decision()) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.WASTELAND) ? new StaticDecision(new IBiomeSpeciesSelector.Decision()) : this.staticOakDecision))))))));
            this.fastTreeLookup.put(biomeId, select);
        }
        return select.getDecision();
    }

    private class RandomDecision
    implements ITreeSelector {
        ArrayList<IBiomeSpeciesSelector.Decision> table = new ArrayList();
        Random rand;

        public RandomDecision(Random rand) {
            this.rand = rand;
        }

        public RandomDecision addSpecies(Species species, int weight) {
            while (weight-- > 0) {
                this.table.add(new IBiomeSpeciesSelector.Decision(species));
            }
            return this;
        }

        public RandomDecision end() {
            this.table.trimToSize();
            return this;
        }

        @Override
        public IBiomeSpeciesSelector.Decision getDecision() {
            return this.table.get(this.rand.nextInt(this.table.size()));
        }
    }

    private class StaticDecision
    implements ITreeSelector {
        IBiomeSpeciesSelector.Decision decision;

        public StaticDecision(IBiomeSpeciesSelector.Decision decision) {
            this.decision = decision;
        }

        @Override
        public IBiomeSpeciesSelector.Decision getDecision() {
            return this.decision;
        }
    }

    private static interface ITreeSelector {
        public IBiomeSpeciesSelector.Decision getDecision();
    }
}

