/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSaplingVanilla;
import com.ferreusveritas.dynamictrees.blocks.BlockFruitCocoa;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.blocks.BlockVerboseFire;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ModBlocks {
    public static BlockRootyDirt blockRootyDirt;
    public static BlockDynamicSapling blockDynamicSapling;
    public static BlockFruitCocoa blockFruitCocoa;
    public static BlockBonsaiPot blockBonsaiPot;
    public static BlockVerboseFire blockVerboseFire;
    public static CommonBlockStates blockStates;

    public static void preInit() {
        blockStates = new CommonBlockStates();
        blockRootyDirt = new BlockRootyDirt();
        blockDynamicSapling = new BlockDynamicSaplingVanilla("sapling");
        blockBonsaiPot = new BlockBonsaiPot();
        blockFruitCocoa = new BlockFruitCocoa();
        blockVerboseFire = new BlockVerboseFire();
    }

    public static void registerBlocks() {
        GameRegistry.register((IForgeRegistryEntry)blockRootyDirt);
        GameRegistry.register((IForgeRegistryEntry)blockDynamicSapling);
        GameRegistry.register((IForgeRegistryEntry)blockBonsaiPot);
        GameRegistry.register((IForgeRegistryEntry)blockFruitCocoa);
        GameRegistry.register((IForgeRegistryEntry)blockVerboseFire);
        ArrayList<Block> treeBlocks = new ArrayList<Block>();
        for (DynamicTree tree : ModTrees.baseTrees) {
            tree.getRegisterableBlocks(treeBlocks);
        }
        for (Block block : treeBlocks) {
            GameRegistry.register((IForgeRegistryEntry)block);
        }
        for (BlockDynamicLeaves leavesBlock : TreeHelper.getLeavesMapForModId("dynamictrees").values()) {
            GameRegistry.register((IForgeRegistryEntry)leavesBlock);
        }
        DynamicTrees.compatProxy.registerBlocks();
    }

    public static class CommonBlockStates {
        public final IBlockState dirt = Blocks.field_150346_d.func_176223_P();
        public final IBlockState podzol = this.dirt.func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        public final IBlockState redMushroom = Blocks.field_150337_Q.func_176223_P();
        public final IBlockState brownMushroom = Blocks.field_150338_P.func_176223_P();
    }
}

