/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.network.IBurningListener;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVerboseFire
extends BlockFire {
    public BlockVerboseFire() {
        this.setRegistryName("fire");
        this.func_149711_c(0.0f);
        this.func_149715_a(1.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149663_c("fire");
        this.func_149649_H();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_82736_K().func_82766_b("doFireTick")) {
            if (!this.func_176196_c(worldIn, pos)) {
                worldIn.func_175698_g(pos);
            }
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            boolean onFireSource = block.isFireSource(worldIn, pos.func_177977_b(), EnumFacing.UP);
            int age = (Integer)state.func_177229_b((IProperty)field_176543_a);
            if (!onFireSource && worldIn.func_72896_J() && this.func_176537_d(worldIn, pos) && rand.nextFloat() < 0.2f + (float)age * 0.03f) {
                worldIn.func_175698_g(pos);
            } else {
                if (age < 15) {
                    state = state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(age + rand.nextInt(3) / 2));
                    worldIn.func_180501_a(pos, state, 4);
                }
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
                if (!onFireSource) {
                    if (!this.func_176533_e(worldIn, pos)) {
                        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || age > 3) {
                            worldIn.func_175698_g(pos);
                        }
                        return;
                    }
                    if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && age == 15 && rand.nextInt(4) == 0) {
                        worldIn.func_175698_g(pos);
                        return;
                    }
                }
                int humidityFactor = worldIn.func_180502_D(pos) ? 1 : 0;
                int chanceDelta = humidityFactor * -50;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    int baseChance = dir.func_176740_k() == EnumFacing.Axis.Y ? 250 : 300;
                    this.tryCatchFire(worldIn, pos.func_177972_a(dir), baseChance + chanceDelta, rand, age, dir.func_176734_d());
                }
                for (BlockPos dPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 4, 1))) {
                    int heat;
                    int neighEncrg;
                    if (dPos.equals((Object)pos)) continue;
                    int distance = 100;
                    int y = dPos.func_177956_o() - pos.func_177956_o();
                    if (y > 1) {
                        distance += (y - 1) * 100;
                    }
                    if ((neighEncrg = this.func_176538_m(worldIn, dPos)) <= 0 || (heat = (neighEncrg + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (age + 30) >> humidityFactor) <= 0 || rand.nextInt(distance) > heat || worldIn.func_72896_J() && this.func_176537_d(worldIn, dPos)) continue;
                    int newAge = MathHelper.clamp(age + rand.nextInt(5) / 4, 0, 15);
                    worldIn.func_180501_a(dPos, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(newAge)), 3);
                }
            }
        }
    }

    public void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int flammability = worldIn.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)worldIn, pos, face);
        if (random.nextInt(chance) < flammability) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int newAge = MathHelper.clamp(age + random.nextInt(5) / 4, 0, 15);
                worldIn.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(newAge)), 3);
            } else {
                worldIn.func_175698_g(pos);
                Block block = iblockstate.func_177230_c();
                if (block instanceof IBurningListener) {
                    ((IBurningListener)block).onBurned(worldIn, iblockstate, pos);
                }
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public boolean func_176533_e(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public int func_176538_m(World worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos)) {
            int encouragementAccumulator = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                encouragementAccumulator = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), encouragementAccumulator);
            }
            return encouragementAccumulator;
        }
        return 0;
    }
}

