/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event;

import com.ferreusveritas.dynamictrees.worldgen.ChunkCircleManager;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CircleEventHandler {
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == 0 && !world.field_72995_K) {
            TreeGenerator.getTreeGenerator().onWorldUnload();
        }
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            byte[] circleData = event.getData().func_74770_j("GTCD");
            TreeGenerator.getTreeGenerator().getChunkCircleManager().setChunkCircleData(event.getChunk().field_76635_g, event.getChunk().field_76647_h, circleData);
        }
    }

    @SubscribeEvent
    public void onChunkDataSave(ChunkDataEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            ChunkCircleManager cm = TreeGenerator.getTreeGenerator().getChunkCircleManager();
            byte[] circleData = cm.getChunkCircleData(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
            NBTTagByteArray circleByteArray = new NBTTagByteArray(circleData);
            event.getData().func_74782_a("GTCD", (NBTBase)circleByteArray);
            if (!event.getChunk().func_177410_o()) {
                cm.unloadChunkCircleData(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
            }
        }
    }
}

