/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.genfeatures;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class GenFeaturePodzol
implements IGenFeature {
    @Override
    public void gen(World world, BlockPos treePos, List<BlockPos> endPoints) {
        if (!endPoints.isEmpty()) {
            Random random = world.field_73012_v;
            BlockPos pos = endPoints.get(random.nextInt(endPoints.size()));
            int x = pos.func_177958_n() + random.nextInt(5) - 2;
            int z = pos.func_177952_p() + random.nextInt(5) - 2;
            int darkThreshold = 4;
            for (int i = 0; i < 32; ++i) {
                Block block;
                BlockPos offPos = new BlockPos(x, pos.func_177956_o() - 1 - i, z);
                if (world.func_175623_d(offPos) || (block = world.func_180495_p(offPos).func_177230_c()) instanceof BlockBranch || block instanceof BlockMushroom || block instanceof BlockLeaves) continue;
                if (block instanceof BlockFlower || block instanceof BlockTallGrass || block instanceof BlockDoublePlant) {
                    if (world.func_175642_b(EnumSkyBlock.SKY, offPos) > 4) continue;
                    world.func_175698_g(pos);
                    continue;
                }
                if (block != Blocks.field_150346_d && block != Blocks.field_150349_c) break;
                if (world.func_175642_b(EnumSkyBlock.SKY, offPos.func_177984_a()) <= 4) {
                    world.func_175656_a(offPos, ModBlocks.blockStates.podzol);
                    break;
                }
                GenFeaturePodzol.spreadPodzol(world, pos);
                break;
            }
        }
    }

    public static void spreadPodzol(World world, BlockPos pos) {
        int Podzolish = 0;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            Block testBlock = world.func_180495_p(deltaPos).func_177230_c();
            Podzolish += testBlock == Blocks.field_150346_d && world.func_180495_p(deltaPos).func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL ? 1 : 0;
            if ((Podzolish += testBlock == ModBlocks.blockRootyDirt ? 1 : 0) < 3) continue;
            world.func_175656_a(pos, ModBlocks.blockStates.podzol);
            break;
        }
    }
}

