/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.genfeatures;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.List;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GenFeatureUndergrowth
implements IGenFeature {
    private Species species;
    private int radius = 2;

    public GenFeatureUndergrowth(Species species) {
        this.species = species;
    }

    public GenFeatureUndergrowth setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public void gen(World world, BlockPos treePos, List<BlockPos> endPoints) {
        Vec3d vTree = new Vec3d((Vec3i)treePos).func_72441_c(0.5, 0.5, 0.5);
        for (int i = 0; i < 2; ++i) {
            IBlockState soilBlockState;
            int rad = MathHelper.clamp(this.radius, 2, world.field_73012_v.nextInt(this.radius - 1) + 2);
            Vec3d v = vTree.func_178787_e(new Vec3d(1.0, 0.0, 0.0).func_186678_a((double)rad).func_178785_b((float)((double)world.field_73012_v.nextFloat() * Math.PI * 2.0)));
            BlockPos pos = TreeHelper.findGround(world, new BlockPos(v));
            if (!this.species.isAcceptableSoil(world, pos, soilBlockState = world.func_180495_p(pos))) continue;
            int type = world.field_73012_v.nextInt(2);
            world.func_175656_a(pos, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)(type == 0 ? BlockPlanks.EnumType.OAK : BlockPlanks.EnumType.JUNGLE)));
            pos = pos.func_177981_b(world.field_73012_v.nextInt(3));
            IBlockState leavesState = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)(type == 0 ? BlockPlanks.EnumType.OAK : BlockPlanks.EnumType.JUNGLE)).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false));
            SimpleVoxmap leafMap = this.species.getTree().getLeafCluster();
            for (BlockPos dPos : leafMap.getAllNonZero()) {
                BlockPos leafPos = pos.func_177971_a((Vec3i)dPos);
                if (GenFeatureUndergrowth.coordHashCode(leafPos) % 5 == 0 || !world.func_180495_p(leafPos).func_177230_c().func_176200_f((IBlockAccess)world, leafPos)) continue;
                world.func_175656_a(leafPos, leavesState);
            }
        }
    }

    public static int coordHashCode(BlockPos pos) {
        int hash = (pos.func_177958_n() * 4111 ^ pos.func_177956_o() * 271 ^ pos.func_177952_p() * 3067) >> 1;
        return hash & 0xFFFF;
    }
}

