/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NodeDestroyer
implements INodeInspector {
    Species species;

    public NodeDestroyer(Species species) {
        this.species = species;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null && this.species.getTree() == branch.getTree()) {
            if (branch.getRadius((IBlockAccess)world, pos) == 1) {
                this.killSurroundingLeaves(world, pos);
            }
            world.func_175698_g(pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void killSurroundingLeaves(World world, BlockPos twigPos) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
            DynamicTree tree = this.species.getTree();
            for (BlockPos leavesPos : BlockPos.func_177980_a((BlockPos)twigPos.func_177982_a(-3, -3, -3), (BlockPos)twigPos.func_177982_a(3, 3, 3))) {
                if (!tree.isCompatibleGenericLeaves((IBlockAccess)world, leavesPos)) continue;
                world.func_175698_g(leavesPos);
                dropList.clear();
                this.species.getTreeHarvestDrops(world, leavesPos, dropList, world.field_73012_v);
                for (ItemStack stack : dropList) {
                    EntityItem itemEntity = new EntityItem(world, (double)leavesPos.func_177958_n() + 0.5, (double)leavesPos.func_177956_o() + 0.5, (double)leavesPos.func_177952_p() + 0.5, stack);
                    CompatHelper.spawnEntity(world, (Entity)itemEntity);
                }
            }
        }
    }
}

