/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NodeFreezer
implements INodeInspector {
    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        int radius;
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null && (radius = branch.getRadius((IBlockAccess)world, pos)) == 1) {
            this.freezeSurroundingLeaves(world, branch, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void freezeSurroundingLeaves(World world, BlockBranch branch, BlockPos twigPos) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            DynamicTree tree = branch.getTree();
            IBlockState primLeaves = tree.getPrimitiveLeaves();
            for (BlockPos leavesPos : BlockPos.func_177980_a((BlockPos)twigPos.func_177982_a(-3, -3, -3), (BlockPos)twigPos.func_177982_a(3, 3, 3))) {
                if (!tree.isCompatibleGenericLeaves((IBlockAccess)world, leavesPos)) continue;
                world.func_175656_a(leavesPos, primLeaves.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

