/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NodeTransform
implements INodeInspector {
    DynamicTree fromTree;
    DynamicTree toTree;

    public NodeTransform(DynamicTree fromTree, DynamicTree toTree) {
        this.fromTree = fromTree;
        this.toTree = toTree;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        int radius;
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null && this.fromTree == branch.getTree() && (radius = branch.getRadius((IBlockAccess)world, pos)) > 0) {
            world.func_175656_a(pos, this.toTree.getDynamicBranch().func_176223_P().func_177226_a((IProperty)BlockBranch.RADIUS, (Comparable)Integer.valueOf(radius)));
            if (radius == 1) {
                this.transformSurroundingLeaves(world, pos);
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void transformSurroundingLeaves(World world, BlockPos twigPos) {
        if (!world.field_72995_K) {
            for (BlockPos leavesPos : BlockPos.func_177980_a((BlockPos)twigPos.func_177982_a(-3, -3, -3), (BlockPos)twigPos.func_177982_a(3, 3, 3))) {
                if (this.fromTree.getLeafClusterPoint(twigPos, leavesPos) == 0 || !this.fromTree.isCompatibleGenericLeaves((IBlockAccess)world, leavesPos)) continue;
                int hydro = 2;
                IBlockState state = world.func_180495_p(leavesPos);
                if (state.func_177230_c() instanceof BlockDynamicLeaves) {
                    BlockDynamicLeaves growingLeaves = (BlockDynamicLeaves)state.func_177230_c();
                    hydro = growingLeaves.getHydrationLevel(state);
                }
                world.func_175656_a(leavesPos, this.toTree.getDynamicLeavesState(hydro));
            }
        }
    }
}

