/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Staff
extends Item {
    public Staff() {
        this("staff");
    }

    public Staff(String name) {
        this.func_77637_a(DynamicTrees.dynamicTreesTab);
        this.func_77625_d(1);
        this.func_77655_b(name);
        this.setRegistryName(name);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Species species;
        ItemStack heldStack = player.func_184586_b(hand);
        IBlockState clickedBlock = world.func_180495_p(pos);
        ITreePart treePart = TreeHelper.getSafeTreePart(clickedBlock);
        BlockPos rootPos = pos;
        BlockBranch branch = TreeHelper.getBranch(treePart);
        if (branch != null) {
            MapSignal signal = branch.analyse(world, pos, null, new MapSignal());
            if (signal.found) {
                rootPos = signal.root;
                treePart = TreeHelper.getSafeTreePart((IBlockAccess)world, rootPos);
            }
        }
        if (!this.isReadOnly(heldStack) && treePart.isRootNode() && (species = DynamicTree.getExactSpecies(world, rootPos)) != null) {
            if (!player.func_70093_af()) {
                String code = new JoCode().buildFromTree(world, rootPos, this.getPlayerDirection(player)).toString();
                this.setCode(heldStack, code);
                GuiScreen.func_146275_d((String)code);
            }
            this.setSpecies(heldStack, species);
            return EnumActionResult.SUCCESS;
        }
        species = this.getSpecies(heldStack);
        if (species != null && species.isAcceptableSoil(world, pos, clickedBlock)) {
            new JoCode(this.getCode(heldStack)).setCareful(true).generate(world, species, pos, world.func_180494_b(pos), this.getPlayerDirection(player), 8);
            CompatHelper.shrinkStack(heldStack, 1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public NBTTagCompound getNBT(ItemStack itemStack) {
        return itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
    }

    public boolean isReadOnly(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74767_n("readonly");
    }

    public Staff setReadOnly(ItemStack itemStack, boolean readonly) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74757_a("readonly", readonly);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Staff setSpecies(ItemStack itemStack, Species species) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a("tree", species.toString());
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Staff setCode(ItemStack itemStack, String code) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a("code", code);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public Species getSpecies(ItemStack itemStack) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b("tree")) {
            return TreeRegistry.findSpecies(new ResourceLocation(nbt.func_74779_i("tree")));
        }
        Species species = TreeRegistry.findSpeciesSloppy("oak");
        this.setSpecies(itemStack, species);
        return species;
    }

    public int getColor(ItemStack itemStack) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        int color = 65535;
        if (nbt.func_74764_b("color")) {
            try {
                color = Color.decode(nbt.func_74779_i("color")).getRGB();
            }
            catch (NumberFormatException e) {
                nbt.func_82580_o("color");
            }
        }
        return color;
    }

    public Staff setColor(ItemStack itemStack, String colStr) {
        NBTTagCompound nbt = this.getNBT(itemStack);
        nbt.func_74778_a("color", colStr);
        itemStack.func_77982_d(nbt);
        return this;
    }

    public String getCode(ItemStack itemStack) {
        String code = "P";
        NBTTagCompound nbt = this.getNBT(itemStack);
        if (nbt.func_74764_b("code")) {
            code = nbt.func_74779_i("code");
        } else {
            nbt.func_74778_a("code", code);
            itemStack.func_77982_d(nbt);
        }
        return code;
    }

    public EnumFacing getPlayerDirection(EntityPlayer player) {
        return player.func_174811_aO();
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Species species = this.getSpecies(stack);
        tooltip.add("Tree: " + (species != null ? species : "none"));
        tooltip.add("Code: \u00a76" + this.getCode(stack));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, 0));
        }
        return multimap;
    }
}

