/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.models.CompositeModel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class BranchModel
implements IModel {
    public ResourceLocation barkTexture;
    public ResourceLocation ringsTexture;

    public BranchModel(ModelBlock modelBlock) {
        this.barkTexture = new ResourceLocation(modelBlock.func_178308_c("bark"));
        this.ringsTexture = new ResourceLocation(modelBlock.func_178308_c("rings"));
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Object[])new ResourceLocation[0]);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf((Object[])new ResourceLocation[]{this.barkTexture, this.ringsTexture});
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            return new CompositeModel(this.barkTexture, this.ringsTexture, bakedTextureGetter);
        }
        catch (Exception exception) {
            System.err.println("BranchModel.bake() failed due to exception:" + exception);
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }
    }

    public IModelState getDefaultState() {
        return null;
    }
}

