/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.proxy;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.models.ModelLoaderBranch;
import com.ferreusveritas.dynamictrees.proxy.CommonProxy;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        this.registerClientEventHandlers();
    }

    @Override
    public void init() {
        super.init();
        this.registerColorHandlers();
    }

    @Override
    public void registerModels() {
        ModelHelper.regModel(ModBlocks.blockRootyDirt);
        ModelHelper.regModel(ModBlocks.blockBonsaiPot);
        Block dendroCoil = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("dynamictrees", "dendrocoil"));
        if (dendroCoil != Blocks.field_150350_a) {
            ModelHelper.regModel(dendroCoil);
        }
        for (DendroPotion.DendroPotionType type : DendroPotion.DendroPotionType.values()) {
            ModelHelper.regModel(ModItems.dendroPotion, type.getIndex());
        }
        ModelHelper.regModel(ModItems.dirtBucket);
        ModelHelper.regModel(ModItems.treeStaff);
        for (DynamicTree tree : ModTrees.baseTrees) {
            ModelHelper.regModel(tree.getDynamicBranch());
            ModelHelper.regModel(tree.getCommonSpecies().getSeed());
            ModelHelper.regModel(tree);
        }
        for (BlockDynamicLeaves leaves : TreeHelper.getLeavesMapForModId("dynamictrees").values()) {
            Item item = Item.func_150898_a((Block)leaves);
            ModelHelper.regModel(item);
        }
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBranch());
    }

    @Override
    public void registerColorHandlers() {
        int white = 0xFFFFFF;
        int magenta = 0xFF00FF;
        ModelHelper.regColorHandler(ModBlocks.blockRootyDirt, new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                return BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos);
            }
        });
        ModelHelper.regColorHandler(ModBlocks.blockDynamicSapling, new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                return ModBlocks.blockDynamicSapling.getSpecies(state).getTree().foliageColorMultiplier(state, world, pos);
            }
        });
        ModelHelper.regColorHandler(ModBlocks.blockBonsaiPot, new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                return ModBlocks.blockBonsaiPot.getTree(state).foliageColorMultiplier(state, world, pos);
            }
        });
        ModelHelper.regColorHandler(ModItems.dendroPotion, new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 0 ? ModItems.dendroPotion.getColor(stack) : 0xFFFFFF;
            }
        });
        ModelHelper.regColorHandler(ModItems.treeStaff, new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 1 ? ModItems.treeStaff.getColor(stack) : 0xFFFFFF;
            }
        });
        for (BlockDynamicLeaves leaves : TreeHelper.getLeavesMapForModId("dynamictrees").values()) {
            ModelHelper.regColorHandler((Block)leaves, new IBlockColor(){

                public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                    Block block = state.func_177230_c();
                    if (TreeHelper.isLeaves(block)) {
                        return ((BlockDynamicLeaves)block).getTree(state).foliageColorMultiplier(state, worldIn, pos);
                    }
                    return 0xFF00FF;
                }
            });
            ModelHelper.regColorHandler(Item.func_150898_a((Block)leaves), new IItemColor(){

                public int func_186726_a(ItemStack stack, int tintIndex) {
                    return ColorizerFoliage.func_77468_c();
                }
            });
        }
    }

    public void makePlantsBlue() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                return 0x6622FF;
            }
        }, new Block[]{Blocks.field_150349_c, Blocks.field_150329_H, Blocks.field_150398_cm, Blocks.field_150362_t, Blocks.field_150361_u});
    }

    public void registerClientEventHandlers() {
    }

    @Override
    public int getTreeFoliageColor(DynamicTree tree, World world, IBlockState blockState, BlockPos pos) {
        return tree.foliageColorMultiplier(blockState, (IBlockAccess)world, pos);
    }

    @Override
    public void addDustParticle(World world, double fx, double fy, double fz, double mx, double my, double mz, IBlockState blockState, float r, float g, float b) {
        if (world.field_72995_K) {
            Particle particle = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), fx, fy, fz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)blockState)});
            particle.func_70538_b(r, g, b);
        }
    }

    @Override
    public void spawnParticle(World world, EnumParticleTypes particleType, double x, double y, double z, double mx, double my, double mz) {
        if (world.field_72995_K) {
            world.func_175688_a(particleType, x, y, z, mx, my, mz, new int[0]);
        }
    }

    @Override
    public void crushLeavesBlock(World world, BlockPos pos, IBlockState blockState, Entity entity) {
        if (world.field_72995_K) {
            BlockDynamicLeaves leaves;
            DynamicTree tree;
            Random random = world.field_73012_v;
            ITreePart treePart = TreeHelper.getTreePart(blockState);
            if (treePart instanceof BlockDynamicLeaves && (tree = (leaves = (BlockDynamicLeaves)treePart).getTree(blockState)) != null) {
                int color = this.getTreeFoliageColor(tree, world, blockState, pos);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                for (int dz = 0; dz < 8; ++dz) {
                    for (int dy = 0; dy < 8; ++dy) {
                        for (int dx = 0; dx < 8; ++dx) {
                            if (random.nextInt(8) != 0) continue;
                            double fx = (double)pos.func_177958_n() + (double)dx / 8.0;
                            double fy = (double)pos.func_177956_o() + (double)dy / 8.0;
                            double fz = (double)pos.func_177952_p() + (double)dz / 8.0;
                            this.addDustParticle(world, fx, fy, fz, 0.0, (double)random.nextFloat() * entity.field_70181_x, 0.0, blockState, r, g, b);
                        }
                    }
                }
            }
        }
    }
}

