/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.IBiomeSuitabilityDecider;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.inspectors.NodeDisease;
import com.ferreusveritas.dynamictrees.inspectors.NodeFindEnds;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.TreeCodeStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;

public class Species
extends IForgeRegistryEntry.Impl<Species> {
    public static IForgeRegistry<Species> REGISTRY;
    protected final DynamicTree treeFamily;
    protected float tapering = 0.3f;
    protected int upProbability = 2;
    protected int lowestBranchHeight = 3;
    protected float signalEnergy = 16.0f;
    protected float growthRate = 1.0f;
    protected int soilLongevity = 8;
    protected Seed seed;
    protected ItemStack seedStack;
    protected IBlockState saplingBlock;
    protected Map<BiomeDictionary.Type, Float> envFactors = new HashMap<BiomeDictionary.Type, Float>();
    protected TreeCodeStore joCodeStore;

    public static void newRegistry(RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("dynamictrees", "species")).setType(Species.class).setIDRange(0, 0x7FFFFFFE).create();
    }

    public Species(ResourceLocation name, DynamicTree treeFamily) {
        this.setRegistryName(name);
        this.treeFamily = treeFamily;
        this.addJoCodes();
    }

    public DynamicTree getTree() {
        return this.treeFamily;
    }

    protected void setBasicGrowingParameters(float tapering, float energy, int upProbability, int lowestBranchHeight, float growthRate) {
        this.tapering = tapering;
        this.signalEnergy = energy;
        this.upProbability = upProbability;
        this.lowestBranchHeight = lowestBranchHeight;
        this.growthRate = growthRate;
    }

    public float getEnergy(World world, BlockPos rootPos) {
        return this.signalEnergy;
    }

    public float getGrowthRate(World world, BlockPos rootPos) {
        return this.growthRate;
    }

    public int getUpProbability() {
        return this.upProbability;
    }

    public float getSecondaryThickness() {
        return 2.0f;
    }

    public int getReinfTravel() {
        return 1;
    }

    public int getLowestBranchHeight() {
        return this.lowestBranchHeight;
    }

    public int getLowestBranchHeight(World world, BlockPos pos) {
        return this.getLowestBranchHeight();
    }

    public float getTapering() {
        return this.tapering;
    }

    public ItemStack getSeedStack(int qty) {
        return CompatHelper.setStackCount(this.seedStack.func_77946_l(), qty);
    }

    public Seed getSeed() {
        return this.seed;
    }

    public Seed generateSeed() {
        this.seed = new Seed(this.getRegistryName().func_110623_a() + "seed");
        return this.setSeedStack(new ItemStack((Item)this.seed));
    }

    public Seed setSeedStack(ItemStack newSeedStack) {
        if (newSeedStack.func_77973_b() instanceof Seed) {
            this.seedStack = newSeedStack;
            this.seed = (Seed)this.seedStack.func_77973_b();
            this.seed.setSpecies(this, this.seedStack);
            return this.seed;
        }
        System.err.println("setSeedStack must have an ItemStack with an Item that is an instance of a Seed");
        return null;
    }

    public float getSeedDropRate() {
        return 1.0f;
    }

    public int getTreeHarvestSeedQuantity(Random random) {
        return random.nextInt(64) == 0 ? 1 : 0;
    }

    public List<ItemStack> getTreeHarvestDrops(World world, BlockPos leafPos, List<ItemStack> list, Random random) {
        int seedQty = this.getTreeHarvestSeedQuantity(random);
        if (seedQty > 0) {
            list.add(this.getSeedStack(seedQty));
        }
        return list;
    }

    public boolean handleVoluntaryDrops(World world, List<BlockPos> endPoints, BlockPos rootPos, BlockPos treePos, int soilLife) {
        float dropRate = this.getSeedDropRate() * ModConfigs.seedDropRate;
        do {
            if (!(dropRate > world.field_73012_v.nextFloat()) || endPoints.size() <= 0) continue;
            BlockPos branchPos = endPoints.get(world.field_73012_v.nextInt(endPoints.size()));
            BlockPos seedPos = this.getRayTraceFruitPos(world, treePos, branchPos = branchPos.func_177984_a());
            if (seedPos == BlockPos.field_177992_a) continue;
            EntityItem seedEntity = new EntityItem(world, (double)seedPos.func_177958_n() + 0.5, (double)seedPos.func_177956_o() + 0.5, (double)seedPos.func_177952_p() + 0.5, this.getSeedStack(1));
            Vec3d motion = new Vec3d((Vec3i)seedPos).func_178788_d(new Vec3d((Vec3i)treePos));
            float distAngle = 15.0f;
            float launchSpeed = 4.0f;
            motion = new Vec3d(motion.field_72450_a, 0.0, motion.field_72448_b).func_72432_b().func_178785_b(world.field_73012_v.nextFloat() * distAngle * 2.0f - distAngle).func_186678_a((double)(launchSpeed / 20.0f));
            seedEntity.field_70159_w = motion.field_72450_a;
            seedEntity.field_70181_x = motion.field_72448_b;
            seedEntity.field_70179_y = motion.field_72449_c;
            CompatHelper.spawnEntity(world, (Entity)seedEntity);
        } while ((dropRate -= 1.0f) > 0.0f);
        return true;
    }

    public boolean handleFruit(World world, List<BlockPos> endPoints, BlockPos rootPos, BlockPos treePos, int soilLife, int qty) {
        int count = 0;
        int attempts = 0;
        if (qty > 0) {
            while (endPoints.size() > 0 && count < qty && attempts < qty * 2) {
                int bSelect = world.field_73012_v.nextInt(endPoints.size());
                BlockPos branchPos = endPoints.get(bSelect);
                ++attempts;
                BlockPos fruitPos = this.getRayTraceFruitPos(world, treePos, branchPos = branchPos.func_177984_a());
                if (fruitPos == BlockPos.field_177992_a || !this.placeFruit(world, fruitPos)) continue;
                ++count;
            }
        }
        return count > 0;
    }

    protected int getFruitQty(World world, BlockPos rootPos) {
        return 0;
    }

    protected IBlockState getFruit(World world, BlockPos fruitPos) {
        return null;
    }

    protected boolean placeFruit(World world, BlockPos fruitPos) {
        IBlockState fruit = this.getFruit(world, fruitPos);
        if (fruit != null) {
            world.func_175656_a(fruitPos, fruit);
            return true;
        }
        return false;
    }

    public BlockPos getRayTraceFruitPos(World world, BlockPos treePos, BlockPos branchPos) {
        RayTraceResult result = this.branchRayTrace(world, treePos, branchPos, 45.0f, 60.0f, 4 + world.field_73012_v.nextInt(3));
        if (result != null) {
            BlockPos hitPos = result.func_178782_a();
            do {
                hitPos = hitPos.func_177977_b();
            } while (this.getTree().isCompatibleGenericLeaves((IBlockAccess)world, hitPos));
            if (world.func_175623_d(hitPos)) {
                return hitPos;
            }
        }
        return BlockPos.field_177992_a;
    }

    public RayTraceResult branchRayTrace(World world, BlockPos treePos, BlockPos branchPos, float spreadHor, float spreadVer, float distance) {
        RayTraceResult result;
        treePos = new BlockPos(treePos.func_177958_n(), branchPos.func_177956_o(), treePos.func_177952_p());
        Vec3d vOut = new Vec3d((double)(branchPos.func_177958_n() - treePos.func_177958_n()), 0.0, (double)(branchPos.func_177952_p() - treePos.func_177952_p()));
        if (vOut.equals((Object)Vec3d.field_186680_a)) {
            vOut = new Vec3d(1.0, 0.0, 0.0);
            spreadHor = 180.0f;
        }
        float deltaYaw = world.field_73012_v.nextFloat() * spreadHor * 2.0f - spreadHor;
        float deltaPitch = world.field_73012_v.nextFloat() * -spreadVer;
        vOut = vOut.func_72432_b().func_72441_c(0.0, Math.tan(Math.toRadians(deltaPitch)), 0.0).func_72432_b().func_178785_b((float)Math.toRadians(deltaYaw)).func_186678_a((double)distance);
        Vec3d branchVec = new Vec3d((Vec3i)branchPos).func_72441_c(0.5, 0.5, 0.5);
        Vec3d vantageVec = branchVec.func_178787_e(vOut);
        BlockPos vantagePos = new BlockPos(vantageVec);
        if (world.func_175623_d(vantagePos) && (result = world.func_147447_a(vantageVec, branchVec, false, true, false)) != null) {
            BlockPos hitPos = result.func_178782_a();
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && hitPos != BlockPos.field_177992_a && this.getTree().isCompatibleGenericLeaves((IBlockAccess)world, hitPos)) {
                return result;
            }
        }
        return null;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
        return drops;
    }

    public Species setDynamicSapling(IBlockState sapling) {
        this.saplingBlock = sapling;
        if (this.saplingBlock.func_177230_c() instanceof BlockDynamicSapling) {
            BlockDynamicSapling dynSap = (BlockDynamicSapling)this.saplingBlock.func_177230_c();
            dynSap.setSpecies(this.saplingBlock, this);
        }
        return this;
    }

    public IBlockState getDynamicSapling() {
        return this.saplingBlock;
    }

    public boolean placeSaplingBlock(World world, BlockPos pos) {
        world.func_175656_a(pos, this.getDynamicSapling());
        return true;
    }

    public boolean canGrowWithBoneMeal(World world, BlockPos pos) {
        return true;
    }

    public boolean canUseBoneMealNow(World world, Random rand, BlockPos pos) {
        return true;
    }

    public BlockRootyDirt getRootyDirtBlock() {
        return ModBlocks.blockRootyDirt;
    }

    public void setSoilLongevity(int longevity) {
        this.soilLongevity = longevity;
    }

    public int getSoilLongevity(World world, BlockPos rootPos) {
        return (int)(this.biomeSuitability(world, rootPos) * (float)this.soilLongevity);
    }

    public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
        Block soilBlock = soilBlockState.func_177230_c();
        return soilBlock == Blocks.field_150346_d || soilBlock == Blocks.field_150349_c || soilBlock == Blocks.field_150391_bh || soilBlock == ModBlocks.blockRootyDirt;
    }

    public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
        return this.isAcceptableSoil(world, pos, soilBlockState);
    }

    public boolean update(World world, BlockRootyDirt rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean rapid) {
        List<BlockPos> ends = this.getEnds(world, treePos, treeBase);
        if (this.handleRot(world, ends, rootPos, treePos, soilLife, rapid)) {
            return false;
        }
        if (!rapid) {
            this.handleVoluntaryDrops(world, ends, rootPos, treePos, soilLife);
            int fruitQty = this.getFruitQty(world, rootPos);
            if (fruitQty > 0) {
                this.handleFruit(world, ends, rootPos, treePos, soilLife, fruitQty);
            }
            if (this.handleDisease(world, treeBase, treePos, random, soilLife)) {
                return true;
            }
        }
        return this.grow(world, rootyDirt, rootPos, soilLife, treeBase, treePos, random, rapid);
    }

    protected final List<BlockPos> getEnds(World world, BlockPos treePos, ITreePart treeBase) {
        NodeFindEnds endFinder = new NodeFindEnds();
        treeBase.analyse(world, treePos, null, new MapSignal(endFinder));
        return endFinder.getEnds();
    }

    public boolean handleRot(World world, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int soilLife, boolean rapid) {
        Iterator<BlockPos> iter = ends.iterator();
        SimpleVoxmap leafMap = this.getTree().getLeafCluster();
        while (iter.hasNext()) {
            float rotChance;
            int radius;
            BlockPos endPos = iter.next();
            IBlockState branchState = world.func_180495_p(endPos);
            BlockBranch branch = TreeHelper.getBranch(branchState);
            if (branch == null || !branch.checkForRot(world, endPos, radius = branch.getRadius(branchState), world.field_73012_v, rotChance = this.rotChance(world, endPos, world.field_73012_v, radius), rapid) && radius == 1) continue;
            if (rapid) {
                TreeHelper.ageVolume(world, endPos.func_177979_c((leafMap.getLenZ() - 1) / 2), (leafMap.getLenX() - 1) / 2, leafMap.getLenY(), null, 2);
            }
            iter.remove();
        }
        return ends.isEmpty() && !TreeHelper.isBranch((IBlockAccess)world, treePos);
    }

    public float rotChance(World world, BlockPos pos, Random rand, int radius) {
        return 0.3f + (float)(8 - radius) * 0.1f;
    }

    public boolean grow(World world, BlockRootyDirt rootyDirt, BlockPos rootPos, int soilLife, ITreePart treeBase, BlockPos treePos, Random random, boolean rapid) {
        float growthRate = this.getGrowthRate(world, rootPos) * ModConfigs.treeGrowthRateMultiplier;
        do {
            if (!(growthRate > random.nextFloat()) || soilLife <= 0) continue;
            boolean success = treeBase.growSignal((World)world, (BlockPos)treePos, (GrowSignal)new GrowSignal((Species)this, (BlockPos)rootPos, (float)this.getEnergy((World)world, (BlockPos)rootPos))).success;
            int soilLongevity = this.getSoilLongevity(world, rootPos) * (success ? 1 : 16);
            if (soilLongevity > 0 && random.nextInt(soilLongevity) != 0) continue;
            rootyDirt.setSoilLife(world, rootPos, soilLife - 1);
        } while ((growthRate -= 1.0f) > 0.0f);
        return this.postGrow(world, rootPos, treePos, soilLife, rapid);
    }

    public EnumFacing selectNewDirection(World world, BlockPos pos, BlockBranch branch, GrowSignal signal) {
        EnumFacing originDir = signal.dir.func_176734_d();
        if (signal.numSteps + 1 <= this.getLowestBranchHeight(world, signal.rootPos)) {
            return EnumFacing.UP;
        }
        int[] probMap = new int[6];
        probMap[EnumFacing.UP.ordinal()] = signal.dir != EnumFacing.DOWN ? this.getUpProbability() : 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + this.getReinfTravel();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir.equals((Object)originDir)) continue;
            BlockPos deltaPos = pos.func_177972_a(dir);
            int n2 = dir.func_176745_a();
            probMap[n2] = probMap[n2] + TreeHelper.getSafeTreePart((IBlockAccess)world, deltaPos).probabilityForBlock((IBlockAccess)world, deltaPos, branch);
        }
        probMap = this.customDirectionManipulation(world, pos, branch.getRadius((IBlockAccess)world, pos), signal, probMap);
        int choice = MathHelper.selectRandomFromDistribution(signal.rand, probMap);
        return this.newDirectionSelected(EnumFacing.func_82600_a((int)(choice != -1 ? choice : 1)), signal);
    }

    protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
        return probMap;
    }

    protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
        return newDir;
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int soilLife, boolean rapid) {
        return true;
    }

    public boolean handleDisease(World world, ITreePart baseTreePart, BlockPos treePos, Random random, int soilLife) {
        if (soilLife == 0 && ModConfigs.diseaseChance > random.nextFloat()) {
            baseTreePart.analyse(world, treePos, EnumFacing.DOWN, new MapSignal(new NodeDisease(this)));
            return true;
        }
        return false;
    }

    public Species envFactor(BiomeDictionary.Type type, float factor) {
        this.envFactors.put(type, Float.valueOf(factor));
        return this;
    }

    public float biomeSuitability(World world, BlockPos pos) {
        IBiomeSuitabilityDecider.Decision override;
        Biome biome = world.func_180494_b(pos);
        if (TreeRegistry.isBiomeSuitabilityOverrideEnabled() && (override = TreeRegistry.getBiomeSuitability(world, biome, this, pos)).isHandled()) {
            return override.getSuitability();
        }
        if (ModConfigs.ignoreBiomeGrowthRate || this.isBiomePerfect(biome)) {
            return 1.0f;
        }
        float s = Species.defaultSuitability();
        for (BiomeDictionary.Type t : BiomeDictionary.getTypes((Biome)biome)) {
            s *= this.envFactors.containsKey(t) ? this.envFactors.get(t).floatValue() : 1.0f;
        }
        return MathHelper.clamp(s, 0.0f, 1.0f);
    }

    public boolean isBiomePerfect(Biome biome) {
        return false;
    }

    public static final float defaultSuitability() {
        return 0.85f;
    }

    public static boolean isOneOfBiomes(Biome biomeToCheck, Biome ... biomes) {
        for (Biome biome : biomes) {
            if (biomeToCheck != biome) continue;
            return true;
        }
        return false;
    }

    public boolean onTreeActivated(World world, BlockPos rootPos, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean generate(World world, BlockPos pos, Biome biome, Random random, int radius) {
        JoCode code;
        EnumFacing facing = CoordUtils.getRandomDir(random);
        if (this.getJoCodeStore() != null && (code = this.getJoCodeStore().getRandomCode(radius, random)) != null) {
            code.generate(world, this, pos, biome, facing, radius);
            return true;
        }
        return false;
    }

    public TreeCodeStore getJoCodeStore() {
        return this.joCodeStore;
    }

    public void addJoCodes() {
        this.joCodeStore = new TreeCodeStore(this);
        this.joCodeStore.addCodesFromFile("assets/" + this.getRegistryName().func_110624_b() + "/trees/" + this.getRegistryName().func_110623_a() + ".txt");
    }

    public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, boolean worldGen) {
    }

    public float getWorldGenTaperingFactor() {
        return 1.5f;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }
}

