/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.cells.CellAcaciaLeaf;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class TreeAcacia
extends DynamicTree {
    Species species;
    protected static final ICell acaciaBranch = new ICell(){
        final int[] map = new int[]{0, 3, 5, 5, 5, 5};

        @Override
        public int getValue() {
            return 5;
        }

        @Override
        public int getValueFromSide(EnumFacing side) {
            return this.map[side.ordinal()];
        }
    };
    protected static final ICell[] acaciaLeafCells = new ICell[]{Cells.nullCell, new CellAcaciaLeaf(1), new CellAcaciaLeaf(2), new CellAcaciaLeaf(3), new CellAcaciaLeaf(4)};

    public TreeAcacia() {
        super(BlockPlanks.EnumType.ACACIA);
        this.setCellSolver(Cells.acaciaSolver);
        this.setSmotherLeavesMax(2);
    }

    @Override
    public void createSpecies() {
        this.species = new SpeciesAcacia((DynamicTree)this);
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        speciesRegistry.register((IForgeRegistryEntry)this.species);
    }

    @Override
    public Species getCommonSpecies() {
        return this.species;
    }

    @Override
    public ICell getCellForBranch(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, BlockBranch branch) {
        return branch.getRadius(blockState) == 1 ? acaciaBranch : Cells.nullCell;
    }

    @Override
    public ICell getCellForLeaves(int hydro) {
        return acaciaLeafCells[hydro];
    }

    @Override
    public void createLeafCluster() {
        this.setLeafCluster(new SimpleVoxmap(7, 2, 7, new byte[]{0, 0, 1, 1, 1, 0, 0, 0, 1, 2, 2, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 1, 2, 4, 0, 4, 2, 1, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 2, 2, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 2, 2, 2, 1, 0, 0, 1, 2, 2, 2, 1, 0, 0, 1, 2, 2, 2, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(3, 0, 3)));
    }

    public class SpeciesAcacia
    extends Species {
        SpeciesAcacia(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.15f, 12.0f, 0, 3, 0.7f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.25f);
            this.envFactor(BiomeDictionary.Type.NETHER, 0.75f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SAVANNA);
        }
    }
}

