/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TreeBirch
extends DynamicTree {
    Species species;

    public TreeBirch() {
        super(BlockPlanks.EnumType.BIRCH);
    }

    @Override
    public void createSpecies() {
        this.species = new SpeciesBirch((DynamicTree)this);
    }

    @Override
    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        speciesRegistry.register((IForgeRegistryEntry)this.species);
    }

    @Override
    public Species getCommonSpecies() {
        return this.species;
    }

    @Override
    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random) {
        if (super.rot(world, pos, neighborCount, radius, random)) {
            if (radius > 4 && TreeHelper.isRootyDirt((IBlockAccess)world, pos.func_177977_b()) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, Blocks.field_150338_P.func_176223_P());
                world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ColorizerFoliage.func_77469_b();
    }

    public class SpeciesBirch
    extends Species {
        SpeciesBirch(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.1f, 14.0f, 4, 4, 1.25f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesBirch.isOneOfBiomes(biome, Biomes.field_150583_P, Biomes.field_150582_Q);
        }
    }
}

