/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class BlockBounds {
    public static final BlockBounds INVALID = new BlockBounds();
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private boolean valid = false;

    public BlockBounds() {
        this.valid = false;
    }

    public BlockBounds(BlockPos pos) {
        this.init(pos);
    }

    public BlockBounds(ChunkPos cPos) {
        this.init(cPos);
    }

    public void init(ChunkPos cPos) {
        this.minX = cPos.func_180334_c();
        this.minY = 0;
        this.minZ = cPos.func_180333_d();
        this.maxX = cPos.func_180332_e();
        this.maxY = 255;
        this.maxZ = cPos.func_180330_f();
        this.valid = true;
    }

    public void init(BlockPos pos) {
        this.minX = this.maxX = pos.func_177958_n();
        this.minY = this.maxY = pos.func_177956_o();
        this.minZ = this.maxZ = pos.func_177952_p();
        this.valid = true;
    }

    public void union(BlockPos pos) {
        if (!this.valid) {
            this.init(pos);
            return;
        }
        if (pos.func_177958_n() < this.minX) {
            this.minX = pos.func_177958_n();
        } else if (pos.func_177958_n() > this.maxX) {
            this.maxX = pos.func_177958_n();
        }
        if (pos.func_177956_o() < this.minY) {
            this.minY = pos.func_177956_o();
        } else if (pos.func_177956_o() > this.maxY) {
            this.maxY = pos.func_177956_o();
        }
        if (pos.func_177952_p() < this.minZ) {
            this.minZ = pos.func_177952_p();
        } else if (pos.func_177952_p() > this.maxZ) {
            this.maxZ = pos.func_177952_p();
        }
    }

    public boolean inBounds(BlockPos pos) {
        return this.valid && pos.func_177958_n() >= this.minX && pos.func_177958_n() <= this.maxX && pos.func_177952_p() >= this.minZ && pos.func_177952_p() <= this.maxZ;
    }

    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public BlockBounds shrink(EnumFacing dir, int amount) {
        switch (dir) {
            case DOWN: {
                this.minY += amount;
                break;
            }
            case UP: {
                this.maxY -= amount;
                break;
            }
            case NORTH: {
                this.minZ += amount;
                break;
            }
            case SOUTH: {
                this.maxZ -= amount;
                break;
            }
            case WEST: {
                this.minX += amount;
                break;
            }
            case EAST: {
                this.maxX -= amount;
            }
        }
        return this;
    }

    public BlockBounds shrinkAll() {
        return this.shrinkAll(1);
    }

    public BlockBounds shrinkAll(int amount) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.shrink(dir, amount);
        }
        return this;
    }

    public BlockBounds shrinkHorizontal() {
        return this.shrinkHorizontal(1);
    }

    public BlockBounds shrinkHorizontal(int amount) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            this.shrink(dir, amount);
        }
        return this;
    }
}

