/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.util.BlockBounds;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SafeChunkBounds {
    private final int centerX;
    private final int centerZ;
    private BlockBounds[] chunkBounds = new BlockBounds[9];
    private int shrink = 0;

    public SafeChunkBounds(World world, BlockPos pos) {
        this.centerX = pos.func_177958_n() >> 4;
        this.centerZ = pos.func_177952_p() >> 4;
        for (Tile t : Tile.values()) {
            int chunkX = this.centerX + t.pos.func_177958_n();
            int chunkZ = this.centerZ + t.pos.func_177952_p();
            this.chunkBounds[t.index] = world.func_190526_b(chunkX, chunkZ) ? new BlockBounds(new ChunkPos(chunkX, chunkZ)) : BlockBounds.INVALID;
        }
        this.rebuildChunkBorders();
    }

    private void rebuildChunkBorders() {
        for (Tile t : Tile.values()) {
            BlockBounds curr = this.chunkBounds[t.index];
            int border = t.borders;
            if (curr == BlockBounds.INVALID) continue;
            int chunkX = this.centerX + t.pos.func_177958_n();
            int chunkZ = this.centerZ + t.pos.func_177952_p();
            curr.init(new ChunkPos(chunkX, chunkZ));
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                boolean validDir = false;
                if ((border & 1 << dir.func_176745_a()) != 0) {
                    BlockBounds inv = this.chunkBounds[t.index + dir.func_82601_c() + dir.func_82599_e() * 3];
                    boolean bl = validDir = inv != BlockBounds.INVALID;
                }
                if (validDir) continue;
                curr.shrink(dir, this.shrink);
            }
        }
    }

    public SafeChunkBounds setShrink(int amount) {
        this.shrink = amount;
        this.rebuildChunkBorders();
        return this;
    }

    public boolean inBounds(BlockPos pos) {
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        int p = 4 + (chunkX - this.centerX) + (chunkZ - this.centerZ) * 3;
        if (this.shrink == 0 && this.chunkBounds[p] != BlockBounds.INVALID) {
            return true;
        }
        return this.chunkBounds[p].inBounds(pos);
    }

    private static enum Tile {
        NW(0, new Vec3i(-1, 0, -1), EnumFacing.SOUTH, EnumFacing.EAST),
        N(1, new Vec3i(0, 0, -1), EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST),
        NE(2, new Vec3i(1, 0, -1), EnumFacing.SOUTH, EnumFacing.WEST),
        W(3, new Vec3i(-1, 0, 0), EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST),
        M(4, new Vec3i(0, 0, 0), EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST),
        E(5, new Vec3i(1, 0, 0), EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST),
        SW(6, new Vec3i(-1, 0, 1), EnumFacing.NORTH, EnumFacing.EAST),
        S(7, new Vec3i(0, 0, 1), EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST),
        SE(8, new Vec3i(1, 0, 1), EnumFacing.NORTH, EnumFacing.WEST);

        public final Vec3i pos;
        public final int borders;
        public final int index;

        private Tile(int index, Vec3i pos, EnumFacing ... dirs) {
            this.index = index;
            this.pos = pos;
            int b = 0;
            for (EnumFacing dir : dirs) {
                b |= 1 << dir.func_176745_a();
            }
            this.borders = b;
        }
    }
}

