/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

public class Vec2i {
    public int x;
    public int z;
    public boolean loose;

    public Vec2i() {
    }

    public Vec2i(int x, int z) {
        this();
        this.set(x, z);
    }

    public Vec2i(Vec2i aCoord) {
        this(aCoord.x, aCoord.z);
        this.setLoose(aCoord.loose);
    }

    public Vec2i set(int x, int z) {
        this.x = x;
        this.z = z;
        return this;
    }

    public Vec2i set(Vec2i other) {
        this.x = other.x;
        this.z = other.z;
        this.loose = other.loose;
        return this;
    }

    public Vec2i setLoose(boolean state) {
        this.loose = state;
        return this;
    }

    public boolean isLoose() {
        return this.loose;
    }

    public Vec2i add(int x, int z) {
        this.x += x;
        this.z += z;
        return this;
    }

    public Vec2i sub(int x, int z) {
        this.x -= x;
        this.z -= z;
        return this;
    }

    public Vec2i add(Vec2i other) {
        return this.add(other.x, other.z);
    }

    public Vec2i sub(Vec2i other) {
        return this.sub(other.x, other.z);
    }

    public double len() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double angle() {
        return Math.atan2(this.z, this.x);
    }

    public static int crossProduct(Vec2i c1, Vec2i c2) {
        return c1.x * c2.z - c1.z * c2.x;
    }

    public boolean equals(Object o) {
        Vec2i v = (Vec2i)o;
        return this.x == v.x && this.z == v.z;
    }

    public int hashCode() {
        return this.x ^ this.z * 98764313;
    }

    public String toString() {
        return "Coord " + this.x + "," + this.z + "," + (this.loose ? "L" : "T");
    }
}

