/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.util.Circle;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.Vec2i;
import com.ferreusveritas.dynamictrees.worldgen.ChunkCircleSet;
import com.ferreusveritas.dynamictrees.worldgen.CircleDebug;
import com.ferreusveritas.dynamictrees.worldgen.CircleHelper;
import com.ferreusveritas.dynamictrees.worldgen.IRadiusCoordinator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ChunkCircleManager {
    IRadiusCoordinator radiusCoordinator;
    HashMap<Vec2i, ChunkCircleSet> chunkCircles = new HashMap();

    public ChunkCircleManager(IRadiusCoordinator radCoord) {
        this.radiusCoordinator = radCoord;
    }

    public synchronized ArrayList<Circle> getCircles(World world, Random random, int chunkX, int chunkZ) {
        ChunkCircleSet cSet = this.getChunkCircleSet(chunkX, chunkZ);
        if (cSet.generated) {
            return this.getChunkCircles(chunkX, chunkZ);
        }
        return this.generateCircles(world, random, chunkX, chunkZ);
    }

    private int getRadiusAtCircleTangent(World world, Circle cA) {
        float angle = (float)cA.getFreeAngle();
        double x = (double)cA.x + (double)(MathHelper.func_76126_a((float)angle) * (float)cA.radius) * 1.5;
        double z = (double)cA.z + (double)(MathHelper.func_76134_b((float)angle) * (float)cA.radius) * 1.5;
        return this.radiusCoordinator.getRadiusAtCoords(world, x, z);
    }

    public ArrayList<Circle> generateCircles(World world, Random random, int chunkX, int chunkZ) {
        int radius;
        ArrayList<Circle> circles = new ArrayList<Circle>(64);
        ArrayList<Circle> unsolvedCircles = new ArrayList<Circle>(64);
        for (Vec3i dir : CoordUtils.surround) {
            this.getChunkCircles(circles, chunkX + dir.func_177958_n(), chunkZ + dir.func_177952_p());
        }
        int chunkXStart = chunkX << 4;
        int chunkZStart = chunkZ << 4;
        for (Circle c : circles) {
            c.edgeMask(chunkXStart, chunkZStart);
        }
        for (int i = 0; i < circles.size() - 1; ++i) {
            for (int j = i + 1; j < circles.size(); ++j) {
                CircleHelper.maskCircles(circles.get(i), circles.get(j));
            }
        }
        if (circles.size() == 0) {
            int x = chunkXStart + random.nextInt(16);
            int z = chunkZStart + random.nextInt(16);
            radius = this.radiusCoordinator.getRadiusAtCoords(world, x, z);
            Circle rootCircle = new Circle(x, z, radius);
            rootCircle.real = true;
            circles.add(rootCircle);
        }
        CircleHelper.gatherUnsolved(unsolvedCircles, circles);
        int count = 0;
        while (!unsolvedCircles.isEmpty()) {
            Circle master = unsolvedCircles.get(0);
            radius = this.getRadiusAtCircleTangent(world, master);
            Circle slave = CircleHelper.findSecondCircle(master, radius);
            Vec2i slavePos = new Vec2i(slave);
            master.arc |= 1 << master.getFreeBit();
            CircleHelper.maskCircles(master, slave, true);
            int i = 0;
            TreeMap<Integer, Circle> intersecting = new TreeMap<Integer, Circle>();
            for (Circle circle : circles) {
                if (!slave.doCirclesIntersectPadding(circle)) continue;
                int depth = 16 + (int)circle.circlePenetration(slave);
                intersecting.put(depth << 8 | i++, circle);
            }
            for (Map.Entry entry : intersecting.entrySet()) {
                Circle master1 = master;
                Circle master2 = (Circle)entry.getValue();
                int cross = Vec2i.crossProduct(new Vec2i(slavePos).sub(master1), new Vec2i(master2).sub(master1));
                if (cross < 0) {
                    Circle temp = master2;
                    master2 = master1;
                    master1 = temp;
                }
                if ((slave = CircleHelper.findThirdCircle(master1, master2, radius)) != null) {
                    for (int ci = 0; ci < circles.size(); ++ci) {
                        Circle c = circles.get(ci);
                        if (!slave.doCirclesIntersect(c)) continue;
                        if (c.real || !c.real && !slave.isInCenterChunk(chunkXStart, chunkZStart)) {
                            slave = null;
                            break;
                        }
                        CircleHelper.fastRemove(circles, ci--);
                    }
                }
                if (slave == null) continue;
                break;
            }
            if (slave != null) {
                slave.edgeMask(chunkXStart, chunkZStart);
                slave.real = slave.isInCenterChunk(chunkXStart, chunkZStart);
                unsolvedCircles.add(slave);
                CircleHelper.solveCircles(unsolvedCircles, circles);
                circles.add(slave);
            }
            CircleHelper.gatherUnsolved(unsolvedCircles, circles);
            if (++count <= 64 || unsolvedCircles.isEmpty()) continue;
            System.err.println("-----" + unsolvedCircles.size() + " unsolved circles-----");
            System.err.println("@ chunk x:" + chunkX + ", z:" + chunkZ);
            System.err.println("after " + count + " iterations");
            for (Circle circle : circles) {
                System.err.println((circle.hasFreeAngles() ? "->" : "  ") + circle);
            }
            CircleDebug.outputCirclesToPng(circles, chunkX, chunkZ, "");
            break;
        }
        ChunkCircleSet cSet = this.getChunkCircleSet(chunkX, chunkZ);
        cSet.generated = true;
        for (Circle c : circles) {
            if (!c.isInCenterChunk(chunkXStart, chunkZStart)) continue;
            cSet.addCircle(c);
        }
        circles.clear();
        return cSet.getCircles(circles, chunkX, chunkZ);
    }

    private ChunkCircleSet getChunkCircleSet(int chunkX, int chunkZ) {
        ChunkCircleSet cSet;
        Vec2i key = new Vec2i(chunkX, chunkZ);
        if (this.chunkCircles.containsKey(key)) {
            cSet = this.chunkCircles.get(key);
        } else {
            cSet = new ChunkCircleSet();
            this.chunkCircles.put(key, cSet);
        }
        return cSet;
    }

    public byte[] getChunkCircleData(int chunkX, int chunkZ) {
        return this.getChunkCircleSet(chunkX, chunkZ).getCircleData();
    }

    public void setChunkCircleData(int chunkX, int chunkZ, byte[] circleData) {
        this.getChunkCircleSet(chunkX, chunkZ).setCircleData(circleData);
    }

    public void unloadChunkCircleData(int chunkX, int chunkZ) {
        this.chunkCircles.remove(new Vec2i(chunkX, chunkZ));
    }

    private ArrayList<Circle> getChunkCircles(int chunkX, int chunkZ) {
        return this.getChunkCircles(new ArrayList<Circle>(), chunkX, chunkZ);
    }

    private ArrayList<Circle> getChunkCircles(ArrayList<Circle> circles, int chunkX, int chunkZ) {
        ChunkCircleSet cSet = this.getChunkCircleSet(chunkX, chunkZ);
        cSet.getCircles(circles, chunkX, chunkZ);
        return circles;
    }
}

