/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDensityProvider;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class DefaultBiomeDensityProvider
implements IBiomeDensityProvider {
    HashMap<Integer, IChance> fastChanceLookup = new HashMap();

    @Override
    public String getName() {
        return "dynamictrees:default";
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public double getDensity(Biome biome, double noiseDensity, Random random) {
        if (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SPOOKY)) {
            return (double)0.4f + noiseDensity / 3.0;
        }
        double naturalDensity = MathHelper.clamp((float)CompatHelper.getBiomeTreesPerChunk(biome) / 10.0f, 0.0f, 1.0f);
        return noiseDensity * naturalDensity;
    }

    @Override
    public IBiomeDensityProvider.EnumChance chance(Biome biome, Species species, int radius, Random random) {
        IChance chance;
        int biomeId = Biome.func_185362_a((Biome)biome);
        if (this.fastChanceLookup.containsKey(biomeId)) {
            chance = this.fastChanceLookup.get(biomeId);
        } else {
            chance = CompatHelper.biomeHasType(biome, BiomeDictionary.Type.CONIFEROUS) ? new IChance(){

                @Override
                public IBiomeDensityProvider.EnumChance getChance(Random random, int radius) {
                    if (radius > 6) {
                        return random.nextFloat() < 0.5f ? IBiomeDensityProvider.EnumChance.OK : IBiomeDensityProvider.EnumChance.CANCEL;
                    }
                    return IBiomeDensityProvider.EnumChance.OK;
                }
            } : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.FOREST) ? new ChanceStatic(IBiomeDensityProvider.EnumChance.OK) : (biome == Biomes.field_185430_ab ? new ChanceStatic(IBiomeDensityProvider.EnumChance.OK) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SWAMP) ? new ChanceRandom(0.75f) : (CompatHelper.getBiomeTreesPerChunk(biome) < 0 ? new ChanceStatic(IBiomeDensityProvider.EnumChance.CANCEL) : new ChanceByRadius()))));
            this.fastChanceLookup.put(biomeId, chance);
        }
        return chance.getChance(random, radius);
    }

    private class ChanceByRadius
    implements IChance {
        private ChanceByRadius() {
        }

        @Override
        public IBiomeDensityProvider.EnumChance getChance(Random random, int radius) {
            float chance = 1.0f;
            if (radius > 3) {
                chance = 2.0f / (float)radius;
                return random.nextFloat() < chance ? IBiomeDensityProvider.EnumChance.OK : IBiomeDensityProvider.EnumChance.CANCEL;
            }
            return random.nextFloat() < chance ? IBiomeDensityProvider.EnumChance.OK : IBiomeDensityProvider.EnumChance.CANCEL;
        }
    }

    private class ChanceRandom
    implements IChance {
        private final float value;

        public ChanceRandom(float value) {
            this.value = value;
        }

        @Override
        public IBiomeDensityProvider.EnumChance getChance(Random random, int radius) {
            return random.nextFloat() < this.value ? IBiomeDensityProvider.EnumChance.OK : IBiomeDensityProvider.EnumChance.CANCEL;
        }
    }

    private class ChanceStatic
    implements IChance {
        private final IBiomeDensityProvider.EnumChance chance;

        public ChanceStatic(IBiomeDensityProvider.EnumChance chance) {
            this.chance = chance;
        }

        @Override
        public IBiomeDensityProvider.EnumChance getChance(Random random, int radius) {
            return this.chance;
        }
    }

    private static interface IChance {
        public IBiomeDensityProvider.EnumChance getChance(Random var1, int var2);
    }
}

