/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.IAgeable;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumParticleTypes;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.blocks.NullTreePart;
import com.ferreusveritas.dynamictrees.inspectors.NodeTwinkle;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.HashMap;
import net.minecraft.block.Block;

public class TreeHelper {
    private static HashMap<String, HashMap<Integer, BlockDynamicLeaves>> modLeavesArray = new HashMap();
    public static final ITreePart nullTreePart = new NullTreePart();

    public static BlockDynamicLeaves getLeavesBlockForSequence(String modid, int seq) {
        int leavesBlockNum;
        int key;
        HashMap<Integer, BlockDynamicLeaves> leavesMap = TreeHelper.getLeavesMapForModId(modid);
        if (leavesMap.containsKey(key = (leavesBlockNum = seq / 4))) {
            return leavesMap.get(key);
        }
        BlockDynamicLeaves leavesBlock = new BlockDynamicLeaves();
        leavesBlock.setRegistryName(modid, "leaves" + leavesBlockNum);
        leavesBlock.setUnlocalizedNameReg("leaves" + leavesBlockNum);
        leavesMap.put(key, leavesBlock);
        return leavesBlock;
    }

    public static HashMap<Integer, BlockDynamicLeaves> getLeavesMapForModId(String modid) {
        HashMap<Integer, BlockDynamicLeaves> leavesMap;
        if (modLeavesArray.containsKey(modid)) {
            leavesMap = modLeavesArray.get(modid);
        } else {
            leavesMap = new HashMap();
            modLeavesArray.put(modid, leavesMap);
        }
        return leavesMap;
    }

    public static void growPulse(World world, BlockPos rootPos) {
        BlockRootyDirt dirt = TreeHelper.getRootyDirt(world, rootPos);
        if (dirt != null) {
            dirt.updateTree(world, rootPos, world.rand, true);
            TreeHelper.ageVolume(world, rootPos, 1);
        }
    }

    public static void ageVolume(World world, BlockPos pos, int iterations) {
        TreeHelper.ageVolume(world, pos, 8, 32, null, iterations);
    }

    public static void ageVolume(World world, BlockPos treePos, int halfWidth, int height, SimpleVoxmap leafMap, int iterations) {
        Iterable<BlockPos> iterable = leafMap != null ? leafMap.getAllNonZero((byte)15) : BlockPos.getAllInBox(treePos.add(new BlockPos(-halfWidth, 0, -halfWidth)), treePos.add(new BlockPos(halfWidth, height, halfWidth)));
        for (int i = 0; i < iterations; ++i) {
            for (BlockPos iPos : iterable) {
                IBlockState blockState = world.getBlockState(iPos);
                Block block = blockState.getBlock();
                if (!(block instanceof IAgeable) || !((IAgeable)block).age(world, iPos, blockState, world.rand, true) || leafMap == null) continue;
                leafMap.setVoxel(iPos, (byte)0);
            }
        }
    }

    public static void treeParticles(World world, BlockPos rootPos, EnumParticleTypes type, int num) {
        if (world.isRemote) {
            TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(new NodeTwinkle(type, num)));
        }
    }

    public static boolean startAnalysisFromRoot(World world, BlockPos rootPos, MapSignal signal) {
        BlockRootyDirt dirt = TreeHelper.getRootyDirt(world, rootPos);
        if (dirt != null) {
            dirt.startAnalysis(world, rootPos, signal);
            return true;
        }
        return false;
    }

    public static BlockPos findGround(World world, BlockPos pos) {
        while (world.getBlockState(pos).isFullCube()) {
            pos = pos.up();
        }
        while (!world.getBlockState(pos).isFullCube() && pos.getY() > 50) {
            pos = pos.down();
        }
        return pos;
    }

    public static boolean isTreePart(Block block) {
        return block instanceof ITreePart;
    }

    public static boolean isTreePart(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isTreePart(blockAccess.getBlockState(pos).getBlock());
    }

    public static ITreePart getTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (ITreePart)block : null;
    }

    public static ITreePart getTreePart(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getTreePart(blockAccess.getBlockState(pos).getBlock());
    }

    public static ITreePart getTreePart(IBlockState state) {
        return TreeHelper.getTreePart(state.getBlock());
    }

    public static ITreePart getSafeTreePart(Block block) {
        return TreeHelper.isTreePart(block) ? (ITreePart)block : nullTreePart;
    }

    public static ITreePart getSafeTreePart(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getSafeTreePart(blockAccess.getBlockState(pos));
    }

    public static ITreePart getSafeTreePart(IBlockState blockState) {
        return TreeHelper.getSafeTreePart(blockState.getBlock());
    }

    public static boolean isBranch(Block block) {
        return block instanceof BlockBranch;
    }

    public static boolean isBranch(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isBranch(blockAccess.getBlockState(pos).getBlock());
    }

    public static boolean isBranch(IBlockState state) {
        return TreeHelper.isBranch(state.getBlock());
    }

    public static BlockBranch getBranch(Block block) {
        return TreeHelper.isBranch(block) ? (BlockBranch)block : null;
    }

    public static BlockBranch getBranch(ITreePart treepart) {
        return treepart instanceof BlockBranch ? (BlockBranch)treepart : null;
    }

    public static BlockBranch getBranch(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getBranch(blockAccess.getBlockState(pos));
    }

    public static BlockBranch getBranch(IBlockState state) {
        return TreeHelper.getBranch(state.getBlock());
    }

    public static boolean isLeaves(Block block) {
        return block instanceof BlockDynamicLeaves;
    }

    public static boolean isLeaves(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isLeaves(blockAccess.getBlockState(pos).getBlock());
    }

    public static boolean isLeaves(IBlockState blockState) {
        return TreeHelper.isLeaves(blockState.getBlock());
    }

    public static boolean isRootyDirt(Block block) {
        return block instanceof BlockRootyDirt;
    }

    public static boolean isRootyDirt(IBlockState soilBlockState) {
        return TreeHelper.isRootyDirt(soilBlockState.getBlock());
    }

    public static boolean isRootyDirt(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.isRootyDirt(blockAccess.getBlockState(pos));
    }

    public static BlockRootyDirt getRootyDirt(Block block) {
        return TreeHelper.isRootyDirt(block) ? (BlockRootyDirt)block : null;
    }

    public static BlockRootyDirt getRootyDirt(IBlockAccess blockAccess, BlockPos pos) {
        return TreeHelper.getRootyDirt(blockAccess.getBlockState(pos).getBlock());
    }
}

