/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api;

import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.treedata.IBiomeSuitabilityDecider;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;

public class TreeRegistry {
    private static ArrayList<IBiomeSuitabilityDecider> biomeSuitabilityDeciders = new ArrayList();
    private static final IBiomeSuitabilityDecider.Decision undecided = new IBiomeSuitabilityDecider.Decision();

    public static Species registerSpecies(Species species) {
        Species.REGISTRY.register(species);
        return species;
    }

    public static void registerSpecies(Species ... values) {
        Species.REGISTRY.registerAll(values);
    }

    public static Species findSpecies(ResourceLocation name) {
        return Species.REGISTRY.getValue(name);
    }

    public static Species findSpeciesSloppy(String name) {
        ResourceLocation resloc = new ResourceLocation(name);
        if (Species.REGISTRY.containsKey(resloc)) {
            return Species.REGISTRY.getValue(resloc);
        }
        if (Species.REGISTRY.containsKey(resloc = new ResourceLocation("dynamictrees", resloc.func_110623_a()))) {
            return Species.REGISTRY.getValue(resloc);
        }
        for (Species species : Species.REGISTRY) {
            if (!species.getRegistryName().func_110623_a().equals(resloc.func_110623_a())) continue;
            return species;
        }
        return null;
    }

    public static void registerBiomeSuitabilityDecider(IBiomeSuitabilityDecider decider) {
        biomeSuitabilityDeciders.add(decider);
    }

    public static IBiomeSuitabilityDecider.Decision getBiomeSuitability(World world, Biome biome, Species species, BlockPos pos) {
        for (IBiomeSuitabilityDecider decider : biomeSuitabilityDeciders) {
            IBiomeSuitabilityDecider.Decision decision = decider.getBiomeSuitability(world, biome, species, pos);
            if (!decision.isHandled()) continue;
            return decision;
        }
        return undecided;
    }

    public static boolean isBiomeSuitabilityOverrideEnabled() {
        return !biomeSuitabilityDeciders.isEmpty();
    }
}

