/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.backport;

import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockBackport;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBackport
extends Block
implements IBlockBackport {
    public IBlockState defBlockState = new BlockState(this);
    public static final AxisAlignedBB FULL_AABB = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    ResourceLocation name;

    protected BlockBackport(Material material) {
        super(material);
    }

    @Override
    public void setDefaultState(IBlockState blockState) {
        this.defBlockState = blockState;
    }

    @Override
    public IBlockState getDefaultState() {
        return this.defBlockState;
    }

    public void func_149674_a(net.minecraft.world.World _world, int x, int y, int z, Random rand) {
        World world = new World(_world);
        BlockPos pos = new BlockPos(x, y, z);
        this.updateTick(world, pos, world.getBlockState(pos), rand);
    }

    @Override
    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_149674_a(world.real(), pos.getX(), pos.getY(), pos.getZ(), rand);
    }

    public boolean func_149727_a(net.minecraft.world.World _world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        World world = new World(_world);
        BlockPos pos = new BlockPos(x, y, z);
        return this.onBlockActivated(world, pos, world.getBlockState(pos), player, EnumHand.MAIN_HAND, player.func_70694_bm(), EnumFacing.getFront(facing), hitX, hitY, hitZ);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.func_149727_a(world.real(), pos.getX(), pos.getY(), pos.getZ(), player, side.getIndex(), hitX, hitY, hitZ);
    }

    public float func_149712_f(net.minecraft.world.World vworld, int x, int y, int z) {
        World world = new World(vworld);
        BlockPos pos = new BlockPos(x, y, z);
        return this.getBlockHardness(world.getBlockState(pos), world, pos);
    }

    @Override
    public float getBlockHardness(IBlockState state, World world, BlockPos pos) {
        return super.func_149712_f(world.real(), pos.getX(), pos.getY(), pos.getZ());
    }

    public int getFlammability(net.minecraft.world.IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.getFlammability(new BlockAccess(world), new BlockPos(x, y, z), EnumFacing.fromForgeDirection(face));
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return super.getFlammability((net.minecraft.world.IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ(), face.toForgeDirection());
    }

    public int getFireSpreadSpeed(net.minecraft.world.IBlockAccess access, int x, int y, int z, ForgeDirection face) {
        return this.getFireSpreadSpeed(new BlockAccess(access), new BlockPos(x, y, z), EnumFacing.fromForgeDirection(face));
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return super.getFireSpreadSpeed((net.minecraft.world.IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ(), face.toForgeDirection());
    }

    public boolean isLadder(net.minecraft.world.IBlockAccess access, int x, int y, int z, EntityLivingBase entity) {
        return this.isLadder(new BlockAccess(access), new BlockPos(x, y, z), entity);
    }

    @Override
    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return super.isLadder((net.minecraft.world.IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ(), entity);
    }

    public void func_149681_a(net.minecraft.world.World world, int x, int y, int z, int localMeta, EntityPlayer player) {
        this.onBlockHarvested(new World(world), new BlockPos(x, y, z), localMeta, player);
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, int localMeta, EntityPlayer player) {
        super.func_149681_a(world.real(), pos.getX(), pos.getY(), pos.getZ(), localMeta, player);
    }

    public void onBlockExploded(net.minecraft.world.World world, int x, int y, int z, Explosion explosion) {
        this.onBlockExploded(new World(world), new BlockPos(x, y, z), explosion);
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(world.real(), pos.getX(), pos.getY(), pos.getZ(), explosion);
    }

    public boolean isWood(net.minecraft.world.IBlockAccess access, int x, int y, int z) {
        return this.isWood(new BlockAccess(access), new BlockPos(x, y, z));
    }

    @Override
    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return super.isWood((net.minecraft.world.IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public int func_149736_g(net.minecraft.world.World world, int x, int y, int z, int side) {
        return this.getComparatorInputOverride(new World(world), new BlockPos(x, y, z), side);
    }

    @Override
    public int getComparatorInputOverride(World world, BlockPos pos, int side) {
        return super.func_149736_g(world.real(), pos.getX(), pos.getY(), pos.getZ(), side);
    }

    public void func_149695_a(net.minecraft.world.World _world, int x, int y, int z, Block block) {
        World world = new World(_world);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.getBlockState(pos);
        this.neighborChanged(state, world, pos, block);
    }

    @Override
    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block) {
        super.func_149695_a(world.real(), pos.getX(), pos.getY(), pos.getZ(), block);
    }

    public boolean func_149718_j(net.minecraft.world.World _world, int x, int y, int z) {
        World world = new World(_world);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.getBlockState(pos);
        return this.canBlockStay(world, pos, state);
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return super.func_149718_j(world.real(), pos.getX(), pos.getY(), pos.getZ());
    }

    public AxisAlignedBB func_149668_a(net.minecraft.world.World world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(new World(world), new BlockPos(x, y, z));
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, BlockPos pos) {
        return super.func_149668_a(world.real(), pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean removedByPlayer(net.minecraft.world.World world, EntityPlayer player, int x, int y, int z, boolean canHarvest) {
        return this.removedByPlayer(new World(world), player, new BlockPos(x, y, z), canHarvest);
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, BlockPos pos, boolean canHarvest) {
        return super.removedByPlayer(world.real(), player, pos.getX(), pos.getY(), pos.getZ(), canHarvest);
    }

    public ArrayList<ItemStack> getDrops(net.minecraft.world.World vworld, int x, int y, int z, int metadata, int fortune) {
        World world = new World(vworld);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.getBlockState(pos);
        return this.getDrops(world, pos, state, fortune);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, BlockPos pos, IBlockState state, int fortune) {
        return super.getDrops(world.real(), pos.getX(), pos.getY(), pos.getZ(), state.getMeta(), fortune);
    }

    protected void func_149642_a(net.minecraft.world.World world, int x, int y, int z, ItemStack stack) {
        this.dropBlockAsItem(new World(world), new BlockPos(x, y, z), stack);
    }

    @Override
    public void dropBlockAsItem(World world, BlockPos pos, ItemStack stack) {
        super.func_149642_a(world.real(), pos.getX(), pos.getY(), pos.getZ(), stack);
    }

    @Override
    public final void dropBlockAsItem(World world, BlockPos pos, int meta, int fortune) {
        super.func_149697_b(world.real(), pos.getX(), pos.getY(), pos.getZ(), meta, fortune);
    }

    public void setRegistryName(String name) {
        ResourceLocation resloc = new ResourceLocation(name);
        ModContainer mc = Loader.instance().activeModContainer();
        String domain = mc.getModId().toLowerCase();
        this.setRegistryName(new ResourceLocation(domain, resloc.func_110623_a()));
    }

    @Override
    public void setRegistryName(ResourceLocation name) {
        this.name = name;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    @Override
    public void setUnlocalizedNameReg(String unlocalName) {
        this.func_149663_c(unlocalName);
    }
}

