/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.backport;

import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.IProperty;
import com.ferreusveritas.dynamictrees.api.backport.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockState
implements IBlockState {
    private final Block block;
    private final int meta;

    public BlockState(Block block, int meta) {
        this.block = block;
        this.meta = meta & 0xF;
    }

    public BlockState(Block block) {
        this(block, 0);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public IBlockState withMeta(int meta) {
        return new BlockState(this.block, meta & 0xF);
    }

    @Override
    public IBlockState withProperty(IProperty property, int value) {
        return new BlockState(this.block, property.apply(value, this.meta));
    }

    @Override
    public int getValue(IProperty property) {
        return property.read(this.meta);
    }

    @Override
    public boolean equals(IBlockState other) {
        return this.getBlock() == other.getBlock() && this.getMeta() == other.getMeta();
    }

    @Override
    public boolean equals(Block block, int meta) {
        return this.equals(block) && this.equals(meta);
    }

    @Override
    public boolean equals(Block block) {
        return block == this.getBlock();
    }

    @Override
    public boolean equals(int meta) {
        return meta == this.getMeta();
    }

    @Override
    public boolean matches(IBlockState otherState, int mask) {
        return this.getBlock() == otherState.getBlock() && (this.getMeta() & mask) == (otherState.getMeta() & mask);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        return this.block.func_149691_a(side, this.meta);
    }

    @Override
    public ItemStack toItemStack(int qty) {
        return new ItemStack(this.block, qty, this.meta);
    }

    @Override
    public ItemStack toItemStack() {
        return this.toItemStack(1);
    }

    @Override
    public Material getMaterial() {
        return this.block.func_149688_o();
    }

    @Override
    public boolean isFullCube() {
        return this.block.func_149686_d();
    }

    @Override
    public boolean isOpaqueCube() {
        return this.block.func_149662_c();
    }

    @Override
    public boolean isSideSolid(World world, BlockPos pos, EnumFacing dir) {
        IBlockState state = world.getBlockState(pos);
        return state.getBlock().isSideSolid((IBlockAccess)world.real(), pos.getX(), pos.getY(), pos.getZ(), dir.toForgeDirection());
    }
}

