/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.backport;

import net.minecraftforge.common.util.ForgeDirection;

public enum EnumFacing {
    DOWN(0, 0, -1, 0),
    UP(1, 0, 1, 0),
    NORTH(2, 0, 0, -1),
    SOUTH(3, 0, 0, 1),
    WEST(4, -1, 0, 0),
    EAST(5, 1, 0, 0);

    private final int index;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    public static final EnumFacing[] VALUES;
    public static final EnumFacing[] HORIZONTALS;
    public static final int[] OPPOSITES;
    public static final int[][] ROTATION_MATRIX;

    private EnumFacing(int i, int x, int y, int z) {
        this.index = i;
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    public int getIndex() {
        return this.index;
    }

    public static EnumFacing fromForgeDirection(ForgeDirection dir) {
        return EnumFacing.getFront(dir.ordinal());
    }

    public ForgeDirection toForgeDirection() {
        return ForgeDirection.getOrientation((int)this.ordinal());
    }

    public int getFrontOffsetX() {
        return this.offsetX;
    }

    public int getFrontOffsetY() {
        return this.offsetY;
    }

    public int getFrontOffsetZ() {
        return this.offsetZ;
    }

    public static EnumFacing getFront(int id) {
        if (id >= 0 && id < VALUES.length) {
            return VALUES[id];
        }
        return null;
    }

    public EnumFacing getOpposite() {
        return EnumFacing.getFront(OPPOSITES[this.ordinal()]);
    }

    public EnumFacing getRotation(ForgeDirection axis) {
        return EnumFacing.getFront(ROTATION_MATRIX[axis.ordinal()][this.ordinal()]);
    }

    static {
        VALUES = new EnumFacing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        HORIZONTALS = new EnumFacing[]{NORTH, SOUTH, WEST, EAST};
        OPPOSITES = new int[]{1, 0, 3, 2, 5, 4, 6};
        ROTATION_MATRIX = new int[][]{{0, 1, 4, 5, 3, 2, 6}, {0, 1, 5, 4, 2, 3, 6}, {5, 4, 2, 3, 0, 1, 6}, {4, 5, 2, 3, 1, 0, 6}, {2, 3, 1, 0, 4, 5, 6}, {3, 2, 0, 1, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};
    }
}

