/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.backport;

import com.ferreusveritas.dynamictrees.api.backport.IProperty;

public class PropertyInteger
implements IProperty {
    private String name;
    private int min = 0;
    private int max = 0;
    private Bits bits = Bits.BXXXX;
    int value = 0;

    public static PropertyInteger create(String name, int min, int max, Bits bits) {
        try {
            return new PropertyInteger(name, min, max, bits);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected PropertyInteger(String name, int min, int max, Bits bits) throws Exception {
        this.name = name;
        this.min = min;
        this.max = max;
        this.bits = bits;
        if (max - min > bits.maxInt) {
            throw new Exception("Range " + min + " - " + max + " to large for available bits:" + bits.maxInt + " in property " + this.name);
        }
    }

    @Override
    public int apply(int input, int meta) {
        if (input >= this.min && input <= this.max) {
            int value = input - this.min;
            meta = this.bits.encode(value, meta);
        } else {
            try {
                throw new Exception("Value out of range in property " + this.name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return meta;
    }

    @Override
    public int read(int meta) {
        return this.min + this.bits.extract(meta);
    }

    public static enum Bits {
        B000X(1, 0, 1),
        B00X0(2, 1, 1),
        B0X00(4, 2, 1),
        BX000(8, 3, 1),
        B00XX(3, 0, 3),
        B0XX0(6, 1, 3),
        BXX00(12, 2, 3),
        B0XXX(7, 0, 7),
        BXXX0(14, 1, 7),
        BXXXX(15, 0, 15);

        private final int mask;
        private final int shift;
        private final int maxInt;

        private Bits(int mask, int shift, int maxInt) {
            this.mask = mask;
            this.shift = shift;
            this.maxInt = maxInt;
        }

        public int extract(int meta) {
            return (meta & this.mask) >> this.shift;
        }

        public int encode(int data, int meta) {
            return meta & ~this.mask | data << this.shift & this.mask;
        }

        public int getMaxInt() {
            return this.maxInt;
        }
    }
}

