/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockBackport;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.PropertyInteger;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.IBurningListener;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.inspectors.NodeDestroyer;
import com.ferreusveritas.dynamictrees.inspectors.NodeNetVolume;
import com.ferreusveritas.dynamictrees.renderers.RendererBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockBranch
extends BlockBackport
implements ITreePart,
IBurningListener {
    private DynamicTree tree;
    public static final PropertyInteger RADIUS = PropertyInteger.create("radius", 1, 8, PropertyInteger.Bits.B0XXX);

    public BlockBranch(String name) {
        super(Material.field_151575_d);
        this.func_149672_a(field_149766_f);
        this.setHarvestLevel("axe", 0);
        this.setDefaultState(this.getDefaultState().withProperty(RADIUS, 1));
        this.setUnlocalizedNameReg(name);
        this.setRegistryName(name);
    }

    public void setTree(DynamicTree tree) {
        this.tree = tree;
    }

    public DynamicTree getTree() {
        return this.tree;
    }

    @Override
    public DynamicTree getTree(IBlockAccess blockAccess, BlockPos pos) {
        return this.getTree();
    }

    @Override
    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isSameWood(ITreePart treepart) {
        return this.isSameWood(TreeHelper.getBranch(treepart));
    }

    public boolean isSameWood(BlockBranch branch) {
        return branch != null && this.getTree() == branch.getTree();
    }

    @Override
    public int branchSupport(IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return this.isSameWood(branch) ? 17 : 0;
    }

    public boolean checkForRot(World world, BlockPos pos, int radius, Random rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.nextFloat() > chance)) {
            return false;
        }
        int neigh = 0;
        for (EnumFacing dir : EnumFacing.VALUES) {
            BlockPos deltaPos = pos.offset(dir);
            if ((neigh += TreeHelper.getSafeTreePart(world, deltaPos).branchSupport(world, this, deltaPos, dir, radius)) < 16 || (neigh & 0xF) < 2) continue;
            return false;
        }
        boolean didRot = this.getTree().rot(world, pos, neigh & 0xF, radius, rand);
        if (rapid && didRot) {
            for (EnumFacing dir : EnumFacing.VALUES) {
                BlockPos neighPos = pos.offset(dir);
                IBlockState state = world.getBlockState(neighPos);
                if (state.getBlock() != this) continue;
                this.checkForRot(world, neighPos, this.getRadius(state), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        DynamicTree tree = TreeHelper.getSafeTreePart(world, pos).getTree(world, pos);
        if (tree != null) {
            return tree.onTreeActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public float getBlockHardness(IBlockState blockState, World world, BlockPos pos) {
        int radius = this.getRadius(world, pos);
        return this.getTree().getPrimitiveLog().getBlock().func_149712_f(world.real(), pos.getX(), pos.getY(), pos.getZ()) * (float)(radius * radius) / 64.0f * 8.0f;
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTree().getPrimitiveLog().getBlock().getFlammability((net.minecraft.world.IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ(), face.toForgeDirection());
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        int radius = this.getRadius(world, pos);
        return this.getTree().getPrimitiveLog().getBlock().getFireSpreadSpeed((net.minecraft.world.IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ(), face.toForgeDirection()) * radius / 8;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(net.minecraft.world.IBlockAccess access, int x, int y, int z, int side) {
        if (RendererBranch.renderFaceFlags == 63) {
            return super.func_149646_a(access, x, y, z, side);
        }
        return (1 << side & RendererBranch.renderFaceFlags) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.getTree().getPrimitiveLog().getIcon((1 << side & RendererBranch.renderRingSides) != 0 ? 0 : 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
    }

    public int func_149645_b() {
        return RendererBranch.id;
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, DynamicTree leavesTree) {
        DynamicTree thisTree = this.getTree();
        if (leavesTree == thisTree) {
            return thisTree.getCellForBranch(blockAccess, pos, blockState, dir, this);
        }
        return Cells.nullCell;
    }

    @Override
    public int getRadius(IBlockAccess blockAccess, BlockPos pos) {
        return this.getRadius(blockAccess.getBlockState(pos));
    }

    public int getRadius(IBlockState blockState) {
        if (blockState.getBlock() == this) {
            return blockState.getValue(RADIUS);
        }
        return 0;
    }

    public void setRadius(World world, BlockPos pos, int radius) {
        world.setBlockState(pos, this.getDefaultState().withProperty(RADIUS, MathHelper.clamp(radius, 1, 8)), 2);
    }

    @Override
    public int probabilityForBlock(IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return this.isSameWood(from) ? this.getRadius(blockAccess, pos) + 2 : 0;
    }

    public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal, int fromRadius) {
        DynamicTree tree = signal.getSpecies().getTree();
        BlockDynamicLeaves leaves = tree.getDynamicLeaves();
        if (leaves != null) {
            if (fromRadius == 1) {
                signal.success = leaves.growLeaves(world, tree, pos, 0);
            } else {
                return leaves.branchOut(world, pos, signal);
            }
        }
        return signal;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            Species species = signal.getSpecies();
            EnumFacing originDir = signal.dir.getOpposite();
            EnumFacing targetDir = this.tree.getCommonSpecies().selectNewDirection(world, pos, this, signal);
            signal.doTurn(targetDir);
            BlockPos deltaPos = pos.offset(targetDir);
            ITreePart treepart = TreeHelper.getTreePart(world, deltaPos);
            if (treepart != null) {
                signal = treepart.growSignal(world, deltaPos, signal);
            } else if (world.isAirBlock(deltaPos)) {
                signal = this.growIntoAir(world, deltaPos, signal, this.getRadius(world, pos));
            }
            float areaAccum = signal.radius * signal.radius;
            for (EnumFacing dir : EnumFacing.VALUES) {
                BlockPos deltaPos2;
                ITreePart treepart2;
                if (dir.equals((Object)originDir) || dir.equals((Object)targetDir) || !this.isSameWood(treepart2 = TreeHelper.getTreePart(world, deltaPos2 = pos.offset(dir)))) continue;
                int branchRadius = treepart2.getRadius(world, deltaPos2);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            signal.radius = MathHelper.clamp((float)Math.sqrt(areaAccum) + species.getTapering(), (float)this.getRadius(world, pos), 8.0f);
            this.setRadius(world, pos, (int)Math.floor(signal.radius));
        }
        return signal;
    }

    @Override
    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public void func_149719_a(net.minecraft.world.IBlockAccess _blockAccess, int x, int y, int z) {
        BlockAccess blockAccess = new BlockAccess(_blockAccess);
        BlockPos pos = new BlockPos(x, y, z);
        int radius = this.getRadius(blockAccess, pos);
        if (radius > 0) {
            float rad = (float)radius / 16.0f;
            float minx = 0.5f - rad;
            float miny = 0.5f - rad;
            float minz = 0.5f - rad;
            float maxx = 0.5f + rad;
            float maxy = 0.5f + rad;
            float maxz = 0.5f + rad;
            boolean connectionMade = false;
            block8: for (EnumFacing dir : EnumFacing.VALUES) {
                if (this.getSideConnectionRadius(blockAccess, pos, radius, dir) <= 0) continue;
                connectionMade = true;
                switch (dir) {
                    case DOWN: {
                        miny = 0.0f;
                        continue block8;
                    }
                    case UP: {
                        maxy = 1.0f;
                        continue block8;
                    }
                    case NORTH: {
                        minz = 0.0f;
                        continue block8;
                    }
                    case SOUTH: {
                        maxz = 1.0f;
                        continue block8;
                    }
                    case WEST: {
                        minx = 0.0f;
                        continue block8;
                    }
                    case EAST: {
                        maxx = 1.0f;
                        continue block8;
                    }
                }
            }
            if (!connectionMade) {
                miny = 0.0f;
                maxy = 1.0f;
            }
            this.func_149676_a(minx, miny, minz, maxx, maxy, maxz);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, BlockPos pos) {
        this.func_149719_a(world, pos.getX(), pos.getY(), pos.getZ());
        return AxisAlignedBB.func_72330_a((double)((double)pos.getX() + this.field_149759_B), (double)((double)pos.getY() + this.field_149760_C), (double)((double)pos.getZ() + this.field_149754_D), (double)((double)pos.getX() + this.field_149755_E), (double)((double)pos.getY() + this.field_149756_F), (double)((double)pos.getZ() + this.field_149757_G));
    }

    @Override
    public int getRadiusForConnection(IBlockAccess world, BlockPos pos, BlockBranch from, int fromRadius) {
        return this.getRadius(world, pos);
    }

    public int getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        BlockPos deltaPos = pos.offset(side);
        return TreeHelper.getSafeTreePart(blockAccess, deltaPos).getRadiusForConnection(blockAccess, deltaPos, this, radius);
    }

    @Override
    public MapSignal analyse(World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        if (signal.depth++ < 32) {
            signal.run(world, this, pos, fromDir);
            for (EnumFacing dir : EnumFacing.VALUES) {
                if (dir == fromDir) continue;
                BlockPos deltaPos = pos.offset(dir);
                signal = TreeHelper.getSafeTreePart(world, deltaPos).analyse(world, deltaPos, dir.getOpposite(), signal);
                if (!signal.found || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(world, this, pos, fromDir);
        } else {
            world.setBlockToAir(pos);
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    public Species getSpeciesFromSignal(World world, MapSignal signal) {
        Species species;
        if (signal.found) {
            BlockRootyDirt rootyDirt = (BlockRootyDirt)world.getBlockState(signal.root).getBlock();
            species = rootyDirt.getSpecies(world, signal.root);
        } else {
            species = this.getTree().getCommonSpecies();
        }
        return species;
    }

    public int destroyTreeFromNode(World world, BlockPos pos) {
        MapSignal signal = this.analyse(world, pos, null, new MapSignal());
        Species species = this.getSpeciesFromSignal(world, signal);
        NodeNetVolume volumeSum = new NodeNetVolume();
        this.analyse(world, pos, signal.localRootDir, new MapSignal(volumeSum, new NodeDestroyer(species)));
        return volumeSum.getVolume();
    }

    public int destroyEntireTree(World world, BlockPos pos) {
        MapSignal signal = this.analyse(world, pos, null, new MapSignal());
        Species species = this.getSpeciesFromSignal(world, signal);
        NodeNetVolume volumeSum = new NodeNetVolume();
        this.analyse(world, pos, null, new MapSignal(volumeSum, new NodeDestroyer(species)));
        return volumeSum.getVolume();
    }

    public List<ItemStack> getWoodDrops(World world, BlockPos pos, int volume) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        volume = (int)((float)volume * ModConfigs.treeHarvestMultiplier);
        DynamicTree tree = this.getTree();
        ItemStack logStack = tree.getPrimitiveLogItemStack(volume / 4096);
        ItemStack stickStack = tree.getStick(volume % 4096 / 512);
        ret.add(logStack);
        ret.add(stickStack);
        return ret;
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, BlockPos pos, boolean canHarvest) {
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        int woodVolume = this.destroyTreeFromNode(world, pos);
        List<ItemStack> items = this.getWoodDrops(world, pos, (int)((float)woodVolume * fortuneFactor));
        float chance = ForgeEventFactory.fireBlockHarvesting(new ArrayList<ItemStack>(items), (net.minecraft.world.World)world.real(), (Block)world.getBlock(pos), (int)pos.getX(), (int)pos.getY(), (int)pos.getZ(), (int)world.getBlockMetadata(pos), (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
        for (ItemStack item : items) {
            if (!(world.rand.nextFloat() <= chance)) continue;
            CompatHelper.spawnItemStackAsEntity(world, pos, item);
        }
        return true;
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, int localMeta, EntityPlayer player) {
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public int func_149656_h() {
        return 2;
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        int woodVolume = this.destroyTreeFromNode(world, pos);
        for (ItemStack item : this.getWoodDrops(world, pos, woodVolume)) {
            CompatHelper.spawnItemStackAsEntity(world, pos, item);
        }
    }

    @Override
    public void onBurned(World world, IBlockState oldState, BlockPos burnedPos) {
        if (oldState.getBlock() == this) {
            for (EnumFacing dir : EnumFacing.VALUES) {
                BlockPos rootPos;
                BlockPos neighPos = burnedPos.offset(dir);
                if (!TreeHelper.isBranch(world, neighPos) || (rootPos = DynamicTree.findRootNode(world, neighPos)) != null) continue;
                this.analyse(world, neighPos, null, new MapSignal(new NodeDestroyer(this.getTree().getCommonSpecies())));
            }
        }
    }

    @Override
    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn) {
        for (EnumFacing dir : EnumFacing.VALUES) {
            BlockPos neighbor = pos.offset(dir);
            IBlockState neighBlockState = world.getBlockState(neighbor);
            if (neighBlockState.getMaterial() != Material.field_151581_o || neighBlockState.getBlock() == ModBlocks.blockVerboseFire) continue;
            int age = neighBlockState.getBlock() == Blocks.field_150480_ab ? neighBlockState.getMeta() : 0;
            world.setBlockState(neighbor, new BlockState((Block)ModBlocks.blockVerboseFire, age));
        }
    }

    @Override
    public boolean isBranch() {
        return true;
    }

    @Override
    public boolean isRootNode() {
        return false;
    }
}

