/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockBackport;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.renderers.RendererSapling;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDynamicSapling
extends BlockBackport
implements IGrowable {
    public Species tree;

    public BlockDynamicSapling(String name) {
        super(Material.field_151585_k);
        this.func_149672_a(field_149779_h);
        this.func_149675_a(true);
        this.setUnlocalizedNameReg(name);
        this.setRegistryName(name);
    }

    @Override
    public void updateTick(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, IBlockState state, Random rand) {
        this.grow(world, rand, pos, state);
    }

    public static boolean canSaplingStay(com.ferreusveritas.dynamictrees.api.backport.World world, Species species, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.HORIZONTALS) {
            IBlockState blockState = world.getBlockState(pos.offset(dir));
            Block block = blockState.getBlock();
            if (!TreeHelper.isBranch(block) && !(block instanceof BlockDynamicSapling)) continue;
            return false;
        }
        return world.isAirBlock(pos.up()) && species.isAcceptableSoil(world, pos.down(), world.getBlockState(pos.down()));
    }

    @Override
    public boolean canBlockStay(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, IBlockState state) {
        return BlockDynamicSapling.canSaplingStay(world, this.getSpecies(state), pos);
    }

    public void func_149853_b(World vworld, Random rand, int x, int y, int z) {
        com.ferreusveritas.dynamictrees.api.backport.World world = new com.ferreusveritas.dynamictrees.api.backport.World(vworld);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.getBlockState(pos);
        this.grow(world, rand, pos, state);
    }

    public void grow(com.ferreusveritas.dynamictrees.api.backport.World world, Random rand, BlockPos pos, IBlockState state) {
        Species species = this.getSpecies(state);
        if (this.canBlockStay(world, pos, state)) {
            DynamicTree tree = species.getTree();
            if (world.isAirBlock(pos.up()) && species.isAcceptableSoil(world, pos.down(), world.getBlockState(pos.down()))) {
                world.setBlockState(pos, tree.getDynamicBranch().getDefaultState());
                world.setBlockState(pos.up(), tree.getDynamicLeavesState());
                world.setBlockState(pos.down(), species.getRootyDirtBlock().getDefaultState());
            }
        } else {
            this.dropBlock(world, species, state, pos);
        }
    }

    public boolean func_149851_a(World vworld, int x, int y, int z, boolean isClient) {
        com.ferreusveritas.dynamictrees.api.backport.World world = new com.ferreusveritas.dynamictrees.api.backport.World(vworld);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.getBlockState(pos);
        return this.getSpecies(state).canGrowWithBoneMeal(world, pos);
    }

    public boolean func_149852_a(World vworld, Random rand, int x, int y, int z) {
        com.ferreusveritas.dynamictrees.api.backport.World world = new com.ferreusveritas.dynamictrees.api.backport.World(vworld);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.getBlockState(pos);
        return this.getSpecies(state).canUseBoneMealNow(world, rand, pos);
    }

    public Species getSpecies(IBlockState state) {
        return this.tree;
    }

    public BlockDynamicSapling setSpecies(IBlockState state, Species species) {
        this.tree = species;
        return this;
    }

    @Override
    public void neighborChanged(IBlockState state, com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, Block blockIn) {
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlock(world, this.getSpecies(state), state, pos);
        }
    }

    private void dropBlock(com.ferreusveritas.dynamictrees.api.backport.World world, Species tree, IBlockState state, BlockPos pos) {
        world.setBlockToAir(pos);
        this.func_149642_a(world.real(), pos.getX(), pos.getY(), pos.getZ(), new ItemStack((Item)tree.getSeed()));
    }

    @Override
    public ArrayList<ItemStack> getDrops(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> dropped = super.getDrops(world, pos, state, fortune);
        dropped.add(this.getSpecies(state).getSeedStack(1));
        return dropped;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public int getDamageValue(com.ferreusveritas.dynamictrees.api.backport.World world, int x, int y, int z) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World _world, int x, int y, int z) {
        com.ferreusveritas.dynamictrees.api.backport.World world = new com.ferreusveritas.dynamictrees.api.backport.World(_world);
        return this.getSpecies(world.getBlockState(new BlockPos(x, y, z))).getSeed();
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.75f, 0.75f);
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.getSpecies(new BlockState(this, metadata)).getTree().getPrimitiveLog().getIcon(2);
    }

    public int func_149645_b() {
        return RendererSapling.id;
    }
}

