/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.GrowSignal;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;

public class NullTreePart
implements ITreePart {
    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, DynamicTree leavesTree) {
        return Cells.nullCell;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    @Override
    public int getRadiusForConnection(IBlockAccess blockAccess, BlockPos pos, BlockBranch from, int fromRadius) {
        return fromRadius == 1 && from.getTree().getPrimitiveLeaves().matches(blockAccess.getBlockState(pos), 3) ? 1 : 0;
    }

    @Override
    public int probabilityForBlock(IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return blockAccess.isAirBlock(pos) ? 1 : 0;
    }

    @Override
    public int getRadius(IBlockAccess blockAccess, BlockPos pos) {
        return 0;
    }

    @Override
    public MapSignal analyse(World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        return signal;
    }

    @Override
    public boolean isRootNode() {
        return false;
    }

    @Override
    public boolean isBranch() {
        return false;
    }

    @Override
    public int branchSupport(IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        if (branch.getTree().getPrimitiveLeaves().matches(blockAccess.getBlockState(pos), 3)) {
            return 1;
        }
        return 0;
    }

    @Override
    public DynamicTree getTree(IBlockAccess blockAccess, BlockPos pos) {
        return null;
    }
}

