/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities;

import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;

public class EntityLingeringEffector
extends Entity {
    public BlockPos blockPos;
    public ISubstanceEffect effect;
    public boolean extended;

    public EntityLingeringEffector(World world, BlockPos pos, ISubstanceEffect effect) {
        super(world.real());
        this.field_70130_N = 1.0f;
        this.field_70131_O = 1.0f;
        this.field_70145_X = true;
        this.setBlockPos(pos);
        this.setEffect(effect);
        if (this.effect != null) {
            for (EntityLingeringEffector effector : world.real().func_72872_a(EntityLingeringEffector.class, pos.getAxisAlignedBB())) {
                if (!effector.getBlockPos().equals(pos) || !effector.getEffect().getName().equals(effect.getName())) continue;
                effector.func_70106_y();
            }
        }
    }

    public void setBlockPos(BlockPos pos) {
        this.blockPos = pos;
        this.func_70107_b((double)this.blockPos.getX() + 0.5, this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void setEffect(ISubstanceEffect effect) {
        this.effect = effect;
    }

    public ISubstanceEffect getEffect() {
        return this.effect;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        World world = CompatHelper.getEntityWorld(this);
        if (this.effect != null) {
            IBlockState blockState = world.getBlockState(this.blockPos);
            if (blockState.getBlock() instanceof BlockRootyDirt) {
                if (!this.effect.update(world, this.blockPos, this.field_70173_aa)) {
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }
}

